/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.CharSet;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.util.string.UTF8StringUtil;

public final class UTF8StringPointable
extends AbstractPointable
implements IHashable,
IComparable {
    private int utf8Length;
    private int metaLength;
    private int hashValue;
    private int stringLength;
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return false;
        }

        public int getFixedLength() {
            return 0;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new UTF8StringPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    @Override
    protected void afterReset() {
        this.utf8Length = UTF8StringUtil.getUTFLength((byte[])this.bytes, (int)this.start);
        this.metaLength = UTF8StringUtil.getNumBytesToStoreLength((int)this.getUTF8Length());
        this.hashValue = 0;
        this.stringLength = -1;
    }

    public static UTF8StringPointable generateUTF8Pointable(String string) {
        byte[] bytes = UTF8StringUtil.writeStringToBytes((String)string);
        UTF8StringPointable ptr = new UTF8StringPointable();
        ptr.set(bytes, 0, bytes.length);
        return ptr;
    }

    public char charAt(int offset) {
        return UTF8StringUtil.charAt((byte[])this.bytes, (int)(this.start + offset));
    }

    public int charSize(int offset) {
        return UTF8StringUtil.charSize((byte[])this.bytes, (int)(this.start + offset));
    }

    public int getStringLength() {
        if (this.stringLength < 0) {
            this.stringLength = UTF8StringUtil.getStringLength((byte[])this.bytes, (int)this.start);
        }
        return this.stringLength;
    }

    public int getUTF8Length() {
        return this.utf8Length;
    }

    public int getMetaDataLength() {
        return this.metaLength;
    }

    public int getCharStartOffset() {
        return this.getStartOffset() + this.getMetaDataLength();
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        return UTF8StringUtil.compareTo((byte[])this.bytes, (int)this.start, (byte[])bytes, (int)start);
    }

    @Override
    public int hash() {
        if (this.hashValue == 0) {
            this.hashValue = UTF8StringUtil.hash((byte[])this.bytes, (int)this.start);
        }
        return this.hashValue;
    }

    public void toString(StringBuilder buffer) {
        UTF8StringUtil.toString((StringBuilder)buffer, (byte[])this.bytes, (int)this.start);
    }

    public String toString() {
        try {
            return new String(this.bytes, this.getCharStartOffset(), this.getUTF8Length(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public int ignoreCaseCompareTo(UTF8StringPointable other) {
        return UTF8StringUtil.lowerCaseCompareTo((byte[])this.getByteArray(), (int)this.getStartOffset(), (byte[])other.getByteArray(), (int)other.getStartOffset());
    }

    public int find(UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.find(this, pattern, ignoreCase);
    }

    public static int find(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.find(src, pattern, ignoreCase, 0);
    }

    public static int find(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase, int startMatch) {
        int srcUtfLen = src.getUTF8Length();
        int pttnUtfLen = pattern.getUTF8Length();
        int srcStart = src.getMetaDataLength();
        int pttnStart = pattern.getMetaDataLength();
        int maxStart = srcUtfLen - pttnUtfLen;
        for (int startMatchPos = startMatch; startMatchPos <= maxStart; startMatchPos += src.charSize(srcStart + startMatchPos)) {
            char ch2;
            char ch1;
            int c2;
            int c1 = startMatchPos;
            for (c2 = 0; c1 < srcUtfLen && c2 < pttnUtfLen && ((ch1 = src.charAt(srcStart + c1)) == (ch2 = pattern.charAt(pttnStart + c2)) || ignoreCase && Character.toLowerCase(ch1) == Character.toLowerCase(ch2)); c1 += src.charSize(srcStart + c1), c2 += pattern.charSize(pttnStart + c2)) {
            }
            if (c2 != pttnUtfLen) continue;
            return startMatchPos;
        }
        return -1;
    }

    public boolean contains(UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.contains(this, pattern, ignoreCase);
    }

    public static boolean contains(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.find(src, pattern, ignoreCase) >= 0;
    }

    public boolean startsWith(UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.startsWith(this, pattern, ignoreCase);
    }

    public static boolean startsWith(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase) {
        char ch2;
        char ch1;
        int c2;
        int utflen1 = src.getUTF8Length();
        int utflen2 = pattern.getUTF8Length();
        if (utflen2 > utflen1) {
            return false;
        }
        int s1Start = src.getMetaDataLength();
        int s2Start = pattern.getMetaDataLength();
        int c1 = 0;
        for (c2 = 0; c1 < utflen1 && c2 < utflen2 && ((ch1 = src.charAt(s1Start + c1)) == (ch2 = pattern.charAt(s2Start + c2)) || ignoreCase && Character.toLowerCase(ch1) == Character.toLowerCase(ch2)); c1 += src.charSize(s1Start + c1), c2 += pattern.charSize(s2Start + c2)) {
        }
        return c2 == utflen2;
    }

    public boolean endsWith(UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.endsWith(this, pattern, ignoreCase);
    }

    public static boolean endsWith(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase) {
        char ch2;
        char ch1;
        int c2;
        int len1 = src.getUTF8Length();
        int len2 = pattern.getUTF8Length();
        if (len2 > len1) {
            return false;
        }
        int s1Start = src.getMetaDataLength();
        int s2Start = pattern.getMetaDataLength();
        int c1 = len1 - len2;
        for (c2 = 0; c1 < len1 && c2 < len2 && ((ch1 = src.charAt(s1Start + c1)) == (ch2 = pattern.charAt(s2Start + c2)) || ignoreCase && Character.toLowerCase(ch1) == Character.toLowerCase(ch2)); c1 += src.charSize(s1Start + c1), c2 += pattern.charSize(s2Start + c2)) {
        }
        return c2 == len2;
    }

    public void concat(UTF8StringPointable next, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.concat(this, next, builder, out);
    }

    public static void concat(UTF8StringPointable first, UTF8StringPointable next, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int firstUtfLen = first.getUTF8Length();
        int nextUtfLen = next.getUTF8Length();
        builder.reset(out, firstUtfLen + nextUtfLen);
        builder.appendUtf8StringPointable(first);
        builder.appendUtf8StringPointable(next);
        builder.finish();
    }

    public void substr(int charOffset, int charLength, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.substr(this, charOffset, charLength, builder, out);
    }

    public static void substr(UTF8StringPointable src, int charOffset, int charLength, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int byteIdx;
        if (charOffset < 0) {
            charOffset = 0;
        }
        if (charLength < 0) {
            charLength = 0;
        }
        int utfLen = src.getUTF8Length();
        int chIdx = 0;
        for (byteIdx = 0; byteIdx < utfLen && chIdx < charOffset; byteIdx += src.charSize(src.getMetaDataLength() + byteIdx), ++chIdx) {
        }
        if (byteIdx >= utfLen) {
            builder.reset(out, 0);
            builder.finish();
            return;
        }
        builder.reset(out, Math.min(utfLen - byteIdx, (int)((double)charLength * 1.0 * (double)byteIdx / (double)chIdx)));
        for (chIdx = 0; byteIdx < utfLen && chIdx < charLength; ++chIdx, byteIdx += src.charSize(src.getMetaDataLength() + byteIdx)) {
            builder.appendChar(src.charAt(src.getMetaDataLength() + byteIdx));
        }
        builder.finish();
    }

    public void substrBefore(UTF8StringPointable match, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.substrBefore(this, match, builder, out);
    }

    public static void substrBefore(UTF8StringPointable src, UTF8StringPointable match, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int byteOffset = UTF8StringPointable.find(src, match, false);
        if (byteOffset < 0) {
            builder.reset(out, 0);
            builder.finish();
            return;
        }
        int srcMetaLen = src.getMetaDataLength();
        builder.reset(out, byteOffset);
        for (int idx = 0; idx < byteOffset; idx += src.charSize(srcMetaLen + idx)) {
            builder.appendChar(src.charAt(srcMetaLen + idx));
        }
        builder.finish();
    }

    public void substrAfter(UTF8StringPointable match, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.substrAfter(this, match, builder, out);
    }

    public static void substrAfter(UTF8StringPointable src, UTF8StringPointable match, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int byteOffset = UTF8StringPointable.find(src, match, false);
        if (byteOffset < 0) {
            builder.reset(out, 0);
            builder.finish();
            return;
        }
        int srcUtfLen = src.getUTF8Length();
        int matchUtfLen = match.getUTF8Length();
        int resultLen = srcUtfLen - byteOffset - matchUtfLen;
        builder.reset(out, resultLen);
        builder.appendUtf8StringPointable(src, src.getCharStartOffset() + byteOffset + matchUtfLen, resultLen);
        builder.finish();
    }

    public void lowercase(UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.lowercase(this, builder, out);
    }

    public static void lowercase(UTF8StringPointable src, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int srcUtfLen = src.getUTF8Length();
        int srcStart = src.getMetaDataLength();
        builder.reset(out, srcUtfLen);
        for (int byteIndex = 0; byteIndex < srcUtfLen; byteIndex += src.charSize(srcStart + byteIndex)) {
            builder.appendChar(Character.toLowerCase(src.charAt(srcStart + byteIndex)));
        }
        builder.finish();
    }

    public void uppercase(UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.uppercase(this, builder, out);
    }

    public static void uppercase(UTF8StringPointable src, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int srcUtfLen = src.getUTF8Length();
        int srcStart = src.getMetaDataLength();
        builder.reset(out, srcUtfLen);
        for (int byteIndex = 0; byteIndex < srcUtfLen; byteIndex += src.charSize(srcStart + byteIndex)) {
            builder.appendChar(Character.toUpperCase(src.charAt(srcStart + byteIndex)));
        }
        builder.finish();
    }

    public void initCap(UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.initCap(this, builder, out);
    }

    public static void initCap(UTF8StringPointable src, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int srcUtfLen = src.getUTF8Length();
        int srcStart = src.getMetaDataLength();
        builder.reset(out, srcUtfLen);
        boolean toUpperCase = true;
        for (int byteIndex = 0; byteIndex < srcUtfLen; byteIndex += src.charSize(srcStart + byteIndex)) {
            char originalChar = src.charAt(srcStart + byteIndex);
            boolean isLetter = Character.isLetter(originalChar);
            char resultChar = toUpperCase && isLetter ? Character.toUpperCase(originalChar) : (isLetter ? Character.toLowerCase(originalChar) : originalChar);
            builder.appendChar(resultChar);
            toUpperCase = !isLetter;
        }
        builder.finish();
    }

    public void trim(UTF8StringBuilder builder, GrowableArray out, boolean left, boolean right, CharSet charSet) throws IOException {
        UTF8StringPointable.trim(this, builder, out, left, right, charSet);
    }

    public static void trim(UTF8StringPointable srcPtr, UTF8StringBuilder builder, GrowableArray out, boolean left, boolean right, CharSet charSet) throws IOException {
        int startIndex;
        int srcUtfLen = srcPtr.getUTF8Length();
        int srcStart = srcPtr.getMetaDataLength();
        if (left) {
            char ch;
            for (startIndex = 0; startIndex < srcUtfLen && charSet.contains(ch = srcPtr.charAt(srcStart + startIndex)); startIndex += srcPtr.charSize(srcStart + startIndex)) {
            }
        }
        int endIndex = srcUtfLen;
        if (right) {
            endIndex = startIndex;
            for (int cursorIndex = startIndex; cursorIndex < srcUtfLen; cursorIndex += srcPtr.charSize(srcStart + cursorIndex)) {
                char ch = srcPtr.charAt(srcStart + cursorIndex);
                if (charSet.contains(ch)) continue;
                endIndex = cursorIndex;
            }
        }
        int len = endIndex - startIndex;
        builder.reset(out, len);
        builder.appendUtf8StringPointable(srcPtr, srcPtr.getStartOffset() + srcStart + startIndex, len);
        builder.finish();
    }

    public boolean findAndReplace(UTF8StringPointable searchPtr, UTF8StringPointable replacePtr, int replaceLimit, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        return UTF8StringPointable.findAndReplace(this, searchPtr, replacePtr, replaceLimit, builder, out);
    }

    public static boolean findAndReplace(UTF8StringPointable srcPtr, UTF8StringPointable searchPtr, UTF8StringPointable replacePtr, int replaceLimit, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int nextIdx;
        if (replaceLimit < 1) {
            return false;
        }
        int curIdx = UTF8StringPointable.find(srcPtr, searchPtr, false);
        if (curIdx < 0) {
            return false;
        }
        int searchUtfLen = searchPtr.getUTF8Length();
        int replaceUtfLen = replacePtr.getUTF8Length();
        int estimatedLen = searchUtfLen > 0 && replaceUtfLen > searchUtfLen ? (int)((long)srcPtr.getUTF8Length() * (long)replaceUtfLen / (long)searchUtfLen) : srcPtr.getUTF8Length();
        builder.reset(out, estimatedLen);
        builder.appendUtf8StringPointable(srcPtr, srcPtr.getCharStartOffset(), curIdx);
        builder.appendUtf8StringPointable(replacePtr);
        curIdx += searchUtfLen;
        for (int limit = replaceLimit - 1; limit > 0 && (nextIdx = UTF8StringPointable.find(srcPtr, searchPtr, false, curIdx)) > 0; --limit) {
            builder.appendUtf8StringPointable(srcPtr, srcPtr.getCharStartOffset() + curIdx, nextIdx - curIdx);
            builder.appendUtf8StringPointable(replacePtr);
            curIdx = nextIdx + searchUtfLen;
        }
        builder.appendUtf8StringPointable(srcPtr, srcPtr.getCharStartOffset() + curIdx, srcPtr.getUTF8Length() - curIdx);
        builder.finish();
        return true;
    }
}

