/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public class ByteArrayPointable
extends AbstractPointable
implements IHashable,
IComparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int contentLength = -1;
    private int metaLength = -1;
    private int hash = 0;
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return false;
        }

        public int getFixedLength() {
            return 0;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new ByteArrayPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    @Override
    protected void afterReset() {
        this.contentLength = ByteArrayPointable.getContentLength(this.getByteArray(), this.getStartOffset());
        this.metaLength = ByteArrayPointable.getNumberBytesToStoreMeta(this.contentLength);
        this.hash = 0;
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] thatBytes, int thatStart, int thatLength) {
        int thisArrayLen = ByteArrayPointable.getContentLength(this.bytes, this.start);
        int thatArrayLen = ByteArrayPointable.getContentLength(thatBytes, thatStart);
        int thisArrayStart = this.getContentStartOffset();
        int thatArrayStart = thatStart + ByteArrayPointable.getNumberBytesToStoreMeta(thatArrayLen);
        int thisIndex = 0;
        for (int thatIndex = 0; thisIndex < thisArrayLen && thatIndex < thatArrayLen; ++thisIndex, ++thatIndex) {
            if (this.bytes[thisArrayStart + thisIndex] == thatBytes[thatArrayStart + thatIndex]) continue;
            return (0xFF & this.bytes[thisArrayStart + thisIndex]) - (0xFF & thatBytes[thatArrayStart + thatIndex]);
        }
        return thisArrayLen - thatArrayLen;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public int getMetaLength() {
        return this.metaLength;
    }

    @Override
    public int hash() {
        if (this.hash == 0) {
            int h = 0;
            int realLength = this.getContentLength();
            int startOffset = this.getContentStartOffset();
            for (int i = 0; i < realLength; ++i) {
                h = 31 * h + this.bytes[startOffset + i];
            }
            this.hash = h;
        }
        return this.hash;
    }

    @Override
    public int getLength() {
        return this.getContentLength() + this.getMetaLength();
    }

    public int getContentStartOffset() {
        return this.getStartOffset() + this.getMetaLength();
    }

    public static byte[] copyContent(ByteArrayPointable bytePtr) {
        return Arrays.copyOfRange(bytePtr.getByteArray(), bytePtr.getContentStartOffset(), bytePtr.getContentStartOffset() + bytePtr.getContentLength());
    }

    public static ByteArrayPointable generatePointableFromPureBytes(byte[] bytes) {
        return ByteArrayPointable.generatePointableFromPureBytes(bytes, 0, bytes.length);
    }

    public static ByteArrayPointable generatePointableFromPureBytes(byte[] bytes, int start, int length) {
        int metaLen = ByteArrayPointable.getNumberBytesToStoreMeta(length);
        byte[] ret = new byte[length + metaLen];
        VarLenIntEncoderDecoder.encode((int)length, (byte[])ret, (int)0);
        for (int i = 0; i < length; ++i) {
            ret[i + metaLen] = bytes[start + i];
        }
        ByteArrayPointable ptr = new ByteArrayPointable();
        ptr.set(ret, 0, ret.length);
        return ptr;
    }

    public static int getContentLength(byte[] bytes, int offset) {
        return VarLenIntEncoderDecoder.decode((byte[])bytes, (int)offset);
    }

    public static int getNumberBytesToStoreMeta(int length) {
        return VarLenIntEncoderDecoder.getBytesRequired((int)length);
    }

    public static int normalize(byte[] bytesPtr, int start) {
        int len = ByteArrayPointable.getContentLength(bytesPtr, start);
        long nk = 0L;
        start += ByteArrayPointable.getNumberBytesToStoreMeta(len);
        for (int i = 0; i < 4; ++i) {
            nk <<= 8;
            if (i >= len) continue;
            nk |= (long)(bytesPtr[start + i] & 0xFF);
        }
        return (int)(nk >> 1);
    }
}

