/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbortTasksWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final JobId jobId;
    private final List<TaskAttemptId> tasks;

    public AbortTasksWork(NodeControllerService ncs, JobId jobId, List<TaskAttemptId> tasks) {
        this.ncs = ncs;
        this.jobId = jobId;
        this.tasks = tasks;
    }

    public void run() {
        Joblet ji;
        IDatasetPartitionManager dpm;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Aborting Tasks: " + this.jobId + ":" + this.tasks);
        }
        if ((dpm = this.ncs.getDatasetPartitionManager()) != null) {
            this.ncs.getDatasetPartitionManager().abortReader(this.jobId);
        }
        if ((ji = this.ncs.getJobletMap().get(this.jobId)) != null) {
            Map<TaskAttemptId, Task> taskMap = ji.getTaskMap();
            for (TaskAttemptId taId : this.tasks) {
                Task task = taskMap.get(taId);
                if (task == null) continue;
                task.abort();
            }
        } else {
            LOGGER.log(Level.WARN, "Joblet couldn't be found. Tasks of job " + this.jobId + " have all either completed or failed");
        }
    }
}

