/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.partitions;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.partitions.IPartition;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.comm.channels.NetworkOutputChannel;
import org.apache.hyracks.control.common.job.PartitionDescriptor;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.control.nc.resources.DefaultDeallocatableRegistry;

public class PartitionManager {
    private final NodeControllerService ncs;
    private final Map<PartitionId, List<IPartition>> availablePartitionMap;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final IWorkspaceFileFactory fileFactory;
    private final Map<PartitionId, NetworkOutputChannel> partitionRequests = new HashMap<PartitionId, NetworkOutputChannel>();
    private final Cache<JobId, JobId> failedJobsCache;

    public PartitionManager(NodeControllerService ncs) {
        this.ncs = ncs;
        this.availablePartitionMap = new HashMap<PartitionId, List<IPartition>>();
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.fileFactory = new WorkspaceFileFactory(this.deallocatableRegistry, ncs.getIoManager());
        this.failedJobsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    public synchronized void registerPartition(PartitionId pid, CcId ccId, TaskAttemptId taId, IPartition partition, PartitionState state, boolean updateToCC) throws HyracksDataException {
        try {
            NetworkOutputChannel writer = this.partitionRequests.remove(pid);
            if (writer != null) {
                writer.setFrameSize(partition.getTaskContext().getInitialFrameSize());
                partition.writeTo((IFrameWriter)writer);
                if (!partition.isReusable()) {
                    return;
                }
            }
            List pList = this.availablePartitionMap.computeIfAbsent(pid, k -> new ArrayList());
            pList.add(partition);
            if (updateToCC) {
                this.updatePartitionState(ccId, pid, taId, partition, state);
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public synchronized IPartition getPartition(PartitionId pid) {
        return this.availablePartitionMap.get(pid).get(0);
    }

    public synchronized void registerPartitionRequest(PartitionId partitionId, NetworkOutputChannel writer) {
        List<IPartition> pList;
        if (this.failedJobsCache.getIfPresent((Object)partitionId.getJobId()) != null) {
            writer.abort();
        }
        if ((pList = this.availablePartitionMap.get(partitionId)) != null && !pList.isEmpty()) {
            IPartition partition = pList.get(0);
            writer.setFrameSize(partition.getTaskContext().getInitialFrameSize());
            partition.writeTo((IFrameWriter)writer);
            if (!partition.isReusable()) {
                this.availablePartitionMap.remove(partitionId);
            }
        } else {
            this.partitionRequests.put(partitionId, writer);
        }
    }

    public IWorkspaceFileFactory getFileFactory() {
        return this.fileFactory;
    }

    public void close() {
        this.deallocatableRegistry.close();
    }

    public synchronized void jobCompleted(JobId jobId, JobStatus status) {
        if (status == JobStatus.FAILURE) {
            this.failedJobsCache.put((Object)jobId, (Object)jobId);
        }
        List<IPartition> jobPartitions = this.unregisterPartitions(jobId);
        List<NetworkOutputChannel> pendingRequests = this.removePendingRequests(jobId, status);
        if (!jobPartitions.isEmpty() || !pendingRequests.isEmpty()) {
            this.ncs.getExecutor().execute(() -> {
                jobPartitions.forEach(IDeallocatable::deallocate);
                pendingRequests.forEach(NetworkOutputChannel::abort);
            });
        }
    }

    public synchronized void jobsCompleted(CcId ccId) {
        this.failedJobsCache.asMap().keySet().removeIf(jobId -> jobId.getCcId().equals((Object)ccId));
    }

    private void updatePartitionState(CcId ccId, PartitionId pid, TaskAttemptId taId, IPartition partition, PartitionState state) throws HyracksDataException {
        PartitionDescriptor desc = new PartitionDescriptor(pid, this.ncs.getId(), taId, partition.isReusable());
        desc.setState(state);
        try {
            this.ncs.getClusterController(ccId).registerPartitionProvider(desc);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private List<IPartition> unregisterPartitions(JobId jobId) {
        ArrayList<IPartition> unregisteredPartitions = new ArrayList<IPartition>();
        Iterator<Map.Entry<PartitionId, List<IPartition>>> i = this.availablePartitionMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<PartitionId, List<IPartition>> entry = i.next();
            PartitionId pid = entry.getKey();
            if (!jobId.equals((Object)pid.getJobId())) continue;
            unregisteredPartitions.addAll((Collection<IPartition>)entry.getValue());
            i.remove();
        }
        return unregisteredPartitions;
    }

    private List<NetworkOutputChannel> removePendingRequests(JobId jobId, JobStatus status) {
        if (status != JobStatus.FAILURE) {
            return Collections.emptyList();
        }
        ArrayList<NetworkOutputChannel> pendingRequests = new ArrayList<NetworkOutputChannel>();
        Iterator<Map.Entry<PartitionId, NetworkOutputChannel>> requestsIterator = this.partitionRequests.entrySet().iterator();
        while (requestsIterator.hasNext()) {
            Map.Entry<PartitionId, NetworkOutputChannel> entry = requestsIterator.next();
            PartitionId partitionId = entry.getKey();
            if (!partitionId.getJobId().equals((Object)jobId)) continue;
            pendingRequests.add(entry.getValue());
            requestsIterator.remove();
        }
        return pendingRequests;
    }
}

