/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IAsyncRequest;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.util.InterruptibleAction;

public class IoRequest
implements IAsyncRequest,
InterruptibleAction {
    private final IOManager ioManager;
    private final BlockingQueue<IoRequest> submittedRequests;
    private final BlockingQueue<IoRequest> freeRequests;
    private State state;
    private IFileHandle fHandle;
    private long offset;
    private ByteBuffer data;
    private ByteBuffer[] dataArray;
    private HyracksDataException failure;
    private int read;
    private int write;
    private long writes;

    public IoRequest(IOManager ioManager, BlockingQueue<IoRequest> submittedRequests, BlockingQueue<IoRequest> freeRequests) {
        this.ioManager = ioManager;
        this.submittedRequests = submittedRequests;
        this.freeRequests = freeRequests;
        this.reset();
    }

    public void reset() {
        this.state = State.INITIAL;
        this.fHandle = null;
        this.data = null;
        this.dataArray = null;
        this.failure = null;
    }

    public void read(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        if (this.state != State.INITIAL) {
            throw new IllegalStateException("Can't request a read operation through a " + (Object)((Object)this.state) + " request");
        }
        this.state = State.READ_REQUESTED;
        this.fHandle = fHandle;
        this.offset = offset;
        this.data = data;
        this.queue();
    }

    public void write(IFileHandle fHandle, long offset, ByteBuffer[] dataArray) throws HyracksDataException {
        if (this.state != State.INITIAL) {
            throw new IllegalStateException("Can't request a write operation through a " + (Object)((Object)this.state) + " request");
        }
        this.state = State.WRITE_REQUESTED;
        this.fHandle = fHandle;
        this.offset = offset;
        this.dataArray = dataArray;
        this.queue();
    }

    public void write(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        if (this.state != State.INITIAL) {
            throw new IllegalStateException("Can't request a write operation through a " + (Object)((Object)this.state) + " request");
        }
        this.state = State.WRITE_REQUESTED;
        this.fHandle = fHandle;
        this.offset = offset;
        this.data = data;
        this.queue();
    }

    private void queue() throws HyracksDataException {
        try {
            this.submittedRequests.put(this);
        }
        catch (InterruptedException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        IoRequest ioRequest = this;
        synchronized (ioRequest) {
            while (this.state != State.OPERATION_FAILED && this.state != State.OPERATION_SUCCEEDED) {
                this.wait();
            }
        }
    }

    synchronized void handle() {
        try {
            if (this.state == State.READ_REQUESTED) {
                this.read = this.ioManager.doSyncRead(this.fHandle, this.offset, this.data);
            } else if (this.state == State.WRITE_REQUESTED) {
                if (this.data != null) {
                    this.write = this.ioManager.doSyncWrite(this.fHandle, this.offset, this.data);
                } else {
                    this.writes = this.ioManager.doSyncWrite(this.fHandle, this.offset, this.dataArray);
                }
            } else {
                throw new IllegalStateException("IO Request with state = " + (Object)((Object)this.state));
            }
            this.state = State.OPERATION_SUCCEEDED;
        }
        catch (Throwable th) {
            this.state = State.OPERATION_FAILED;
            this.failure = HyracksDataException.create((Throwable)th);
        }
        this.notifyAll();
    }

    public State getState() {
        return this.state;
    }

    void recycle() {
        this.reset();
        this.freeRequests.offer(this);
    }

    public int getRead() {
        return this.read;
    }

    public int getWrite() {
        return this.write;
    }

    public long getWrites() {
        return this.writes;
    }

    public void run() throws InterruptedException {
        this.await();
    }

    public HyracksDataException getFailure() {
        return this.failure;
    }

    public static enum State {
        INITIAL,
        READ_REQUESTED,
        WRITE_REQUESTED,
        OPERATION_FAILED,
        OPERATION_SUCCEEDED;

    }
}

