/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;

public class FileHandle
implements IFileHandle {
    private final FileReference fileRef;
    private RandomAccessFile raf;
    private String mode;

    public FileHandle(FileReference fileRef) {
        this.fileRef = fileRef;
    }

    public void open(IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws IOException {
        if (!this.fileRef.getFile().exists()) {
            throw HyracksDataException.create((int)30, (Serializable[])new Serializable[]{this.fileRef.getAbsolutePath()});
        }
        block0 : switch (rwMode) {
            case READ_ONLY: {
                this.mode = "r";
                break;
            }
            case READ_WRITE: {
                switch (syncMode) {
                    case METADATA_ASYNC_DATA_ASYNC: {
                        this.mode = "rw";
                        break block0;
                    }
                    case METADATA_ASYNC_DATA_SYNC: {
                        this.mode = "rwd";
                        break block0;
                    }
                    case METADATA_SYNC_DATA_SYNC: {
                        this.mode = "rws";
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.ensureOpen();
    }

    public void close() throws IOException {
        if (this.raf == null) {
            return;
        }
        this.raf.close();
        this.raf = null;
    }

    public FileReference getFileReference() {
        return this.fileRef;
    }

    public FileChannel getFileChannel() {
        return this.raf.getChannel();
    }

    public synchronized void ensureOpen() throws HyracksDataException {
        if (this.raf == null || !this.raf.getChannel().isOpen()) {
            try {
                this.raf = new RandomAccessFile(this.fileRef.getFile(), this.mode);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }
}

