/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.heartbeat;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.control.common.base.IClusterController;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatTask
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long ONE_SECOND_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private final String ncId;
    private final HeartbeatData hbData;
    private final Semaphore delayBlock = new Semaphore(0);
    private final IClusterController cc;
    private final long heartbeatPeriodNanos;

    public HeartbeatTask(String ncId, HeartbeatData hbData, IClusterController cc, long heartbeatPeriod) {
        this.ncId = ncId;
        this.hbData = hbData;
        this.cc = cc;
        this.heartbeatPeriodNanos = TimeUnit.MILLISECONDS.toNanos(heartbeatPeriod);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                long delayNanos;
                long nextFireNanoTime = System.nanoTime() + this.heartbeatPeriodNanos;
                boolean success = this.execute();
                long l = delayNanos = success ? nextFireNanoTime - System.nanoTime() : ONE_SECOND_NANOS;
                if (delayNanos > 0L) {
                    this.delayBlock.tryAcquire(delayNanos, TimeUnit.NANOSECONDS);
                    continue;
                }
                LOGGER.warn("After sending heartbeat, next one is already late by " + TimeUnit.NANOSECONDS.toMillis(-delayNanos) + "ms; sending without delay");
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        LOGGER.log(Level.INFO, "Heartbeat task interrupted; shutting down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute() throws InterruptedException {
        try {
            HeartbeatData heartbeatData = this.hbData;
            synchronized (heartbeatData) {
                this.cc.nodeHeartbeat(this.ncId, this.hbData);
            }
            LOGGER.log(Level.DEBUG, "Successfully sent heartbeat");
            return true;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.log(Level.DEBUG, "Exception sending heartbeat; will retry after 1s", (Throwable)e);
            } else {
                LOGGER.log(Level.ERROR, "Exception sending heartbeat; will retry after 1s: " + e.toString());
            }
            return false;
        }
    }
}

