/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.dataset;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.partitions.ResultSetPartitionId;
import org.apache.hyracks.comm.channels.NetworkOutputChannel;
import org.apache.hyracks.control.nc.dataset.DatasetMemoryManager;
import org.apache.hyracks.control.nc.dataset.DatasetPartitionManager;
import org.apache.hyracks.control.nc.dataset.ResultState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatasetPartitionReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DatasetPartitionManager datasetPartitionManager;
    private final DatasetMemoryManager datasetMemoryManager;
    private final Executor executor;
    private final ResultState resultState;

    public DatasetPartitionReader(DatasetPartitionManager datasetPartitionManager, DatasetMemoryManager datasetMemoryManager, Executor executor, ResultState resultState) {
        this.datasetPartitionManager = datasetPartitionManager;
        this.datasetMemoryManager = datasetMemoryManager;
        this.executor = executor;
        this.resultState = resultState;
    }

    public void writeTo(IFrameWriter writer) {
        this.executor.execute(new ResultPartitionSender((NetworkOutputChannel)writer));
    }

    private class ResultPartitionSender
    implements Runnable {
        private final NetworkOutputChannel channel;

        ResultPartitionSender(NetworkOutputChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.channel.setFrameSize(DatasetPartitionReader.this.resultState.getFrameSize());
            this.channel.open();
            try {
                DatasetPartitionReader.this.resultState.readOpen();
                long offset = 0L;
                ByteBuffer buffer = ByteBuffer.allocate(DatasetPartitionReader.this.resultState.getFrameSize());
                while (true) {
                    buffer.clear();
                    long size = this.read(offset, buffer);
                    if (size <= 0L) break;
                    if (size < (long)buffer.limit()) {
                        throw new IllegalStateException("Premature end of file - readSize: " + size + " buffer limit: " + buffer.limit());
                    }
                    offset += size;
                    buffer.flip();
                    this.channel.nextFrame(buffer);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("result reading successful(" + DatasetPartitionReader.this.resultState.getResultSetPartitionId() + ")");
                }
            }
            catch (Exception e) {
                LOGGER.error(() -> "failed to send result partition " + DatasetPartitionReader.this.resultState.getResultSetPartitionId(), (Throwable)e);
                this.channel.abort();
            }
            finally {
                this.close();
            }
        }

        private long read(long offset, ByteBuffer buffer) throws HyracksDataException {
            return DatasetPartitionReader.this.datasetMemoryManager != null ? DatasetPartitionReader.this.resultState.read(DatasetPartitionReader.this.datasetMemoryManager, offset, buffer) : DatasetPartitionReader.this.resultState.read(offset, buffer);
        }

        private void close() {
            try {
                this.channel.close();
                DatasetPartitionReader.this.resultState.readClose();
                if (DatasetPartitionReader.this.resultState.isExhausted()) {
                    ResultSetPartitionId partitionId = DatasetPartitionReader.this.resultState.getResultSetPartitionId();
                    DatasetPartitionReader.this.datasetPartitionManager.removePartition(partitionId.getJobId(), partitionId.getResultSetId(), partitionId.getPartition());
                }
            }
            catch (HyracksDataException e) {
                LOGGER.error("unexpected failure in partition reader clean up", (Throwable)e);
            }
        }
    }
}

