/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hyracks.api.application.INCApplication;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.config.ConfigUtils;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.BaseNCApplication;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kohsuke.args4j.CmdLineException;

public class NCDriver {
    private static final Logger LOGGER = LogManager.getLogger();

    private NCDriver() {
    }

    public static void main(String[] args) {
        try {
            String nodeId = ConfigUtils.getOptionValue((String[])args, (IOption)NCConfig.Option.NODE_ID);
            ConfigManager configManager = new ConfigManager(args);
            INCApplication application = NCDriver.getApplication(args);
            application.registerConfig((IConfigManager)configManager);
            NCConfig ncConfig = new NCConfig(nodeId, configManager);
            NodeControllerService ncService = new NodeControllerService(ncConfig, application);
            ncService.start();
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (CmdLineException e) {
            LOGGER.log(Level.DEBUG, "Exception parsing command line: " + Arrays.toString(args), (Throwable)e);
            System.exit(2);
        }
        catch (Exception e) {
            LOGGER.error("Exiting NCDriver due to exception", (Throwable)e);
            System.exit(1);
        }
    }

    private static INCApplication getApplication(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        String appClassName = ConfigUtils.getOptionValue((String[])args, (IOption)NCConfig.Option.APP_CLASS);
        return appClassName != null ? (INCApplication)Class.forName(appClassName).newInstance() : BaseNCApplication.INSTANCE;
    }
}

