/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyAbstractCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class LSMBTreeWithBuddySearchCursor
extends LSMBTreeWithBuddyAbstractCursor {
    private int currentCursor = 0;
    private final PermutingTupleReference buddyBTreeTuple;

    public LSMBTreeWithBuddySearchCursor(ILSMIndexOperationContext opCtx, int[] buddyBTreeFields) {
        super(opCtx);
        this.buddyBTreeTuple = new PermutingTupleReference(buddyBTreeFields);
    }

    @Override
    public void doDestroy() throws HyracksDataException {
        super.doDestroy();
        this.currentCursor = 0;
    }

    public void doClose() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        this.currentCursor = 0;
        this.foundNext = false;
        try {
            for (int i = 0; i < this.numberOfTrees; ++i) {
                this.btreeCursors[i].close();
                this.buddyBtreeCursors[i].close();
            }
            this.btreeCursors = null;
            this.buddyBtreeCursors = null;
        }
        finally {
            this.lsmHarness.endSearch(this.opCtx);
        }
    }

    private void searchNextCursor() throws HyracksDataException {
        if (this.currentCursor < this.numberOfTrees) {
            this.btreeCursors[this.currentCursor].close();
            this.btreeAccessors[this.currentCursor].search((IIndexCursor)this.btreeCursors[this.currentCursor], (ISearchPredicate)this.btreeRangePredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doHasNext() throws HyracksDataException {
        if (this.foundNext) {
            return true;
        }
        while (this.currentCursor < this.numberOfTrees) {
            while (this.btreeCursors[this.currentCursor].hasNext()) {
                this.btreeCursors[this.currentCursor].next();
                ITupleReference currentTuple = this.btreeCursors[this.currentCursor].getTuple();
                this.buddyBTreeTuple.reset(this.btreeCursors[this.currentCursor].getTuple());
                boolean killerTupleFound = false;
                for (int i = 0; i < this.currentCursor && !killerTupleFound; ++i) {
                    if (this.buddyBtreeBloomFilters[i] != null && !this.buddyBtreeBloomFilters[i].contains((ITupleReference)this.buddyBTreeTuple, this.hashes)) continue;
                    this.buddyBtreeCursors[i].close();
                    this.buddyBtreeRangePredicate.setHighKey((ITupleReference)this.buddyBTreeTuple, true);
                    this.buddyBtreeRangePredicate.setLowKey((ITupleReference)this.buddyBTreeTuple, true);
                    this.buddyBtreeAccessors[i].search((IIndexCursor)this.buddyBtreeCursors[i], (ISearchPredicate)this.buddyBtreeRangePredicate);
                    try {
                        if (!this.buddyBtreeCursors[i].hasNext()) continue;
                        killerTupleFound = true;
                        continue;
                    }
                    finally {
                        this.buddyBtreeCursors[i].close();
                    }
                }
                if (killerTupleFound) continue;
                this.frameTuple = currentTuple;
                this.foundNext = true;
                return true;
            }
            this.btreeCursors[this.currentCursor].close();
            ++this.currentCursor;
            this.searchNextCursor();
        }
        return false;
    }

    public void doNext() throws HyracksDataException {
        this.foundNext = false;
    }

    public ITupleReference getFilterMinTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMaxTuple();
    }

    private ILSMComponentFilter getFilter() {
        if (this.currentCursor < 0) {
            return null;
        }
        return ((ILSMComponent)this.operationalComponents.get(this.currentCursor)).getLSMComponentFilter();
    }

    @Override
    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        super.doOpen(initialState, searchPred);
        this.searchNextCursor();
    }
}

