/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.MergeOperation;
import org.apache.hyracks.storage.common.IIndexCursor;

public class LSMBTreeWithBuddyMergeOperation
extends MergeOperation {
    private final FileReference buddyBtreeMergeTarget;
    private final FileReference bloomFilterMergeTarget;
    private final boolean keepDeletedTuples;

    public LSMBTreeWithBuddyMergeOperation(ILSMIndexAccessor accessor, IIndexCursor cursor, FileReference target, FileReference buddyBtreeMergeTarget, FileReference bloomFilterMergeTarget, ILSMIOOperationCallback callback, String indexIdentifier, boolean keepDeletedTuples) {
        super(accessor, target, callback, indexIdentifier, cursor);
        this.buddyBtreeMergeTarget = buddyBtreeMergeTarget;
        this.bloomFilterMergeTarget = bloomFilterMergeTarget;
        this.keepDeletedTuples = keepDeletedTuples;
    }

    public FileReference getBuddyBTreeTarget() {
        return this.buddyBtreeMergeTarget;
    }

    public FileReference getBloomFilterTarget() {
        return this.bloomFilterMergeTarget;
    }

    public boolean isKeepDeletedTuples() {
        return this.keepDeletedTuples;
    }

    public LSMComponentFileReferences getComponentFiles() {
        return new LSMComponentFileReferences(this.target, this.buddyBtreeMergeTarget, this.bloomFilterMergeTarget);
    }
}

