/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;

public class LSMBTreeFileManager
extends AbstractLSMIndexFileManager {
    private static final FilenameFilter btreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith("b");
    private final TreeIndexFactory<? extends ITreeIndex> btreeFactory;
    private final boolean hasBloomFilter;

    public LSMBTreeFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> btreeFactory, boolean hasBloomFilter) {
        super(ioManager, file, null);
        this.btreeFactory = btreeFactory;
        this.hasBloomFilter = hasBloomFilter;
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String ts = this.getCurrentTimestamp();
        String baseName = ts + "_" + ts;
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), null, this.hasBloomFilter ? this.baseDir.getChild(baseName + "_" + "f") : null);
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) throws HyracksDataException {
        String[] firstTimestampRange = firstFileName.split("_");
        String[] lastTimestampRange = lastFileName.split("_");
        String baseName = firstTimestampRange[0] + "_" + lastTimestampRange[1];
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), null, this.hasBloomFilter ? this.baseDir.getChild(baseName + "_" + "f") : null);
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        FilenameFilter transactionFilter = this.getTransactionFileFilter(false);
        this.cleanupAndGetValidFilesInternal(this.getCompoundFilter(transactionFilter, btreeFilter), this.btreeFactory, allBTreeFiles);
        HashSet<String> btreeFilesSet = new HashSet<String>();
        for (AbstractLSMIndexFileManager.ComparableFileName cmpFileName : allBTreeFiles) {
            int index = cmpFileName.fileName.lastIndexOf("_");
            btreeFilesSet.add(cmpFileName.fileName.substring(0, index));
        }
        if (this.hasBloomFilter) {
            this.validateFiles(btreeFilesSet, allBloomFilterFiles, this.getCompoundFilter(transactionFilter, bloomFilterFilter), null);
            if (allBTreeFiles.size() != allBloomFilterFiles.size()) {
                throw HyracksDataException.create((int)87, (Serializable[])new Serializable[]{this.baseDir});
            }
        }
        if (allBTreeFiles.isEmpty() || this.hasBloomFilter && allBloomFilterFiles.isEmpty()) {
            return validFiles;
        }
        if (!(allBTreeFiles.size() != 1 || this.hasBloomFilter && allBloomFilterFiles.size() != 1)) {
            validFiles.add(new LSMComponentFileReferences(((AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get((int)0)).fileRef, null, this.hasBloomFilter ? ((AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get((int)0)).fileRef : null));
            return validFiles;
        }
        Collections.sort(allBTreeFiles);
        if (this.hasBloomFilter) {
            Collections.sort(allBloomFilterFiles);
        }
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBTreeFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get(0);
        validComparableBTreeFiles.add(lastBTree);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBloomFilterFiles = null;
        AbstractLSMIndexFileManager.ComparableFileName lastBloomFilter = null;
        if (this.hasBloomFilter) {
            validComparableBloomFilterFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
            lastBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(0);
            validComparableBloomFilterFiles.add(lastBloomFilter);
        }
        AbstractLSMIndexFileManager.ComparableFileName currentBloomFilter = null;
        for (int i = 1; i < allBTreeFiles.size(); ++i) {
            AbstractLSMIndexFileManager.ComparableFileName currentBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get(i);
            if (this.hasBloomFilter) {
                currentBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(i);
            }
            if (!(currentBTree.interval[0].compareTo(lastBTree.interval[1]) <= 0 || this.hasBloomFilter && currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[1]) <= 0)) {
                validComparableBTreeFiles.add(currentBTree);
                lastBTree = currentBTree;
                if (!this.hasBloomFilter) continue;
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentBTree.interval[0].compareTo(lastBTree.interval[0]) >= 0 && currentBTree.interval[1].compareTo(lastBTree.interval[1]) <= 0 && (!this.hasBloomFilter || currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[0]) >= 0 && currentBloomFilter.interval[1].compareTo(lastBloomFilter.interval[1]) <= 0)) {
                IoUtil.delete((File)new File(currentBTree.fullPath));
                if (!this.hasBloomFilter) continue;
                IoUtil.delete((File)new File(currentBloomFilter.fullPath));
                continue;
            }
            throw HyracksDataException.create((int)84, (Serializable[])new Serializable[]{this.baseDir});
        }
        Collections.sort(validComparableBTreeFiles, this.recencyCmp);
        Iterator btreeFileIter = validComparableBTreeFiles.iterator();
        Iterator bloomFilterFileIter = null;
        if (this.hasBloomFilter) {
            Collections.sort(validComparableBloomFilterFiles, this.recencyCmp);
            bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        }
        AbstractLSMIndexFileManager.ComparableFileName cmpBTreeFileName = null;
        AbstractLSMIndexFileManager.ComparableFileName cmpBloomFilterFileName = null;
        while (btreeFileIter.hasNext() && (!this.hasBloomFilter || bloomFilterFileIter.hasNext())) {
            cmpBTreeFileName = (AbstractLSMIndexFileManager.ComparableFileName)btreeFileIter.next();
            if (this.hasBloomFilter) {
                cmpBloomFilterFileName = (AbstractLSMIndexFileManager.ComparableFileName)bloomFilterFileIter.next();
            }
            validFiles.add(new LSMComponentFileReferences(cmpBTreeFileName.fileRef, null, this.hasBloomFilter ? cmpBloomFilterFileName.fileRef : null));
        }
        return validFiles;
    }

    public LSMComponentFileReferences getNewTransactionFileReference() throws IOException {
        String ts = this.getCurrentTimestamp();
        IoUtil.create((FileReference)this.baseDir.getChild(".T" + ts));
        String baseName = ts + "_" + ts;
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), null, this.baseDir.getChild(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getTransactionFileReferenceForCommit() throws HyracksDataException {
        String[] files = this.baseDir.getFile().list(txnFileNameFilter);
        if (files.length == 0) {
            return null;
        }
        if (files.length != 1) {
            throw HyracksDataException.create((int)85, (Serializable[])new Serializable[]{this.baseDir});
        }
        FilenameFilter transactionFilter = this.getTransactionFileFilter(true);
        FileReference txnFile = this.baseDir.getChild(files[0]);
        files = this.baseDir.getFile().list(transactionFilter);
        IoUtil.delete((FileReference)txnFile);
        FileReference bTreeFileRef = null;
        FileReference bloomFilterFileRef = null;
        for (String fileName : files) {
            if (fileName.endsWith("b")) {
                bTreeFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            if (fileName.endsWith("f")) {
                bloomFilterFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            throw HyracksDataException.create((int)86, (Serializable[])new Serializable[]{fileName});
        }
        return new LSMComponentFileReferences(bTreeFileRef, null, bloomFilterFileRef);
    }
}

