/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.sync;

import java.io.IOException;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.replication.messaging.CheckpointPartitionIndexesTask;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.replication.sync.ReplicaFilesSynchronizer;

public class ReplicaSynchronizer {
    private final INcApplicationContext appCtx;
    private final PartitionReplica replica;

    public ReplicaSynchronizer(INcApplicationContext appCtx, PartitionReplica replica) {
        this.appCtx = appCtx;
        this.replica = replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws IOException {
        Object syncLock;
        Object object = syncLock = this.appCtx.getReplicaManager().getReplicaSyncLock();
        synchronized (object) {
            this.syncFiles();
            this.checkpointReplicaIndexes();
            this.appCtx.getReplicationManager().register((IPartitionReplica)this.replica);
        }
    }

    private void syncFiles() throws IOException {
        ReplicaFilesSynchronizer fileSync = new ReplicaFilesSynchronizer(this.appCtx, this.replica);
        fileSync.sync();
        IReplicationStrategy replStrategy = this.appCtx.getReplicationManager().getReplicationStrategy();
        this.appCtx.getDatasetLifecycleManager().flushDataset(replStrategy);
        fileSync.sync();
    }

    private void checkpointReplicaIndexes() throws IOException {
        CheckpointPartitionIndexesTask task = new CheckpointPartitionIndexesTask(this.replica.getIdentifier().getPartition());
        ReplicationProtocol.sendTo(this.replica, task);
        ReplicationProtocol.waitForAck(this.replica);
    }
}

