/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.logging.RemoteLogRecord;
import org.apache.asterix.replication.logging.RemoteLogsProcessor;
import org.apache.asterix.replication.management.ReplicationChannel;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ReplicateLogsTask
implements IReplicaTask {
    public static final int END_REPLICATION_LOG_SIZE = 1;
    private final String nodeId;

    public ReplicateLogsTask(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) {
        ReplicationChannel replicationChannel = (ReplicationChannel)appCtx.getReplicationChannel();
        RemoteLogsProcessor logsProcessor = replicationChannel.getRemoteLogsProcessor();
        ILogManager logManager = appCtx.getTransactionSubsystem().getLogManager();
        RemoteLogRecord reusableLog = new RemoteLogRecord();
        SocketChannel channel = worker.getChannel();
        ByteBuffer logsBuffer = ByteBuffer.allocate(logManager.getLogPageSize());
        try {
            while ((logsBuffer = ReplicationProtocol.readRequest(channel, logsBuffer)).remaining() != 1) {
                logsProcessor.process(logsBuffer, reusableLog, worker);
            }
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.REPLICATE_LOGS;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeUTF(this.nodeId);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static ReplicateLogsTask create(DataInput input) throws IOException {
        String node = input.readUTF();
        return new ReplicateLogsTask(node);
    }
}

