/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;

public class ComponentMaskTask
implements IReplicaTask {
    private final String file;

    public ComponentMaskTask(String file) {
        this.file = file;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) {
        try {
            Path maskPath = ComponentMaskTask.getComponentMaskPath(appCtx, this.file);
            Files.createFile(maskPath, new FileAttribute[0]);
            ReplicationProtocol.sendAck(worker.getChannel(), worker.getReusableBuffer());
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    public static Path getComponentMaskPath(INcApplicationContext appCtx, String componentFile) throws IOException {
        IIOManager ioManager = appCtx.getIoManager();
        FileReference localPath = ioManager.resolve(componentFile);
        Path resourceDir = Files.createDirectories(localPath.getFile().getParentFile().toPath(), new FileAttribute[0]);
        String componentId = PersistentLocalResourceRepository.getComponentId((String)componentFile);
        return Paths.get(resourceDir.toString(), ".mask_C_" + componentId);
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.LSM_COMPONENT_MASK;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeUTF(this.file);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static ComponentMaskTask create(DataInput input) throws IOException {
        String indexFile = input.readUTF();
        return new ComponentMaskTask(indexFile);
    }
}

