/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.logging;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.replication.management.LogReplicationManager;

public class ReplicationLogBuffer {
    private final int logBufferSize;
    private final AtomicBoolean full;
    private int appendOffset;
    private int replicationOffset;
    private final ByteBuffer appendBuffer;
    private final ByteBuffer replicationBuffer;
    private boolean stop;
    private final LogReplicationManager replicationManager;
    private final int batchSize;

    public ReplicationLogBuffer(LogReplicationManager replicationManager, int logBufferSize, int batchSize) {
        this.replicationManager = replicationManager;
        this.logBufferSize = logBufferSize;
        this.batchSize = batchSize;
        this.appendBuffer = ByteBuffer.allocate(logBufferSize);
        this.replicationBuffer = this.appendBuffer.duplicate();
        this.full = new AtomicBoolean(false);
        this.appendOffset = 0;
        this.replicationOffset = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ILogRecord logRecord) {
        this.appendBuffer.putInt(logRecord.getRemoteLogSize());
        logRecord.writeRemoteLogRecord(this.appendBuffer);
        ReplicationLogBuffer replicationLogBuffer = this;
        synchronized (replicationLogBuffer) {
            this.appendOffset += ReplicationLogBuffer.getLogReplicationSize(logRecord);
            this.notify();
        }
    }

    public synchronized void isFull(boolean full) {
        this.full.set(full);
        this.notify();
    }

    public boolean hasSpace(ILogRecord logRecord) {
        return this.appendOffset + ReplicationLogBuffer.getLogReplicationSize(logRecord) <= this.logBufferSize;
    }

    private static int getLogReplicationSize(ILogRecord logRecord) {
        return 4 + logRecord.getRemoteLogSize();
    }

    public void reset() {
        this.appendBuffer.position(0);
        this.appendBuffer.limit(this.logBufferSize);
        this.replicationBuffer.position(0);
        this.replicationBuffer.limit(this.logBufferSize);
        this.full.set(false);
        this.appendOffset = 0;
        this.replicationOffset = 0;
        this.stop = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        while (!this.full.get()) {
            int endOffset;
            ReplicationLogBuffer replicationLogBuffer = this;
            synchronized (replicationLogBuffer) {
                if (this.appendOffset - this.replicationOffset == 0 && !this.full.get()) {
                    try {
                        if (this.stop) {
                            break;
                        }
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                }
                endOffset = this.appendOffset;
            }
            this.internalFlush(this.replicationOffset, endOffset);
        }
        this.internalFlush(this.replicationOffset, this.appendOffset);
    }

    private void internalFlush(int beginOffset, int endOffset) {
        if (endOffset > beginOffset) {
            int begingPos = this.replicationBuffer.position();
            this.replicationBuffer.limit(endOffset);
            this.transferBuffer(this.replicationBuffer);
            this.replicationBuffer.position(begingPos + (endOffset - beginOffset));
            this.replicationOffset = endOffset;
        }
    }

    private void transferBuffer(ByteBuffer buffer) {
        if (buffer.remaining() <= this.batchSize) {
            this.replicationManager.transferBatch(buffer);
            return;
        }
        int totalTransferLimit = buffer.limit();
        while (buffer.hasRemaining()) {
            if (buffer.remaining() > this.batchSize) {
                int logSize;
                buffer.mark();
                for (int currentBatchSize = 0; currentBatchSize < this.batchSize; currentBatchSize += logSize + 4) {
                    logSize = this.replicationBuffer.getInt();
                    buffer.position(buffer.position() + logSize);
                }
                buffer.limit(buffer.position());
                buffer.reset();
            }
            this.replicationManager.transferBatch(buffer);
            buffer.limit(totalTransferLimit);
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public void isStop(boolean stop) {
        this.stop = stop;
    }

    public int getLogBufferSize() {
        return this.logBufferSize;
    }

    public LogReplicationManager getReplicationManager() {
        return this.replicationManager;
    }
}

