/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.utils;

import java.util.List;
import org.apache.asterix.app.resource.OperatorResourcesComputer;
import org.apache.asterix.app.resource.PlanStage;
import org.apache.asterix.app.resource.PlanStagesGenerator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.job.resource.ClusterCapacity;
import org.apache.hyracks.api.job.resource.IClusterCapacity;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static IClusterCapacity getRequiredCapacity(ILogicalPlan plan, AlgebricksAbsolutePartitionConstraint computationLocations, PhysicalOptimizationConfig physicalOptimizationConfig) throws AlgebricksException {
        int frameSize = physicalOptimizationConfig.getFrameSize();
        int sortFrameLimit = physicalOptimizationConfig.getMaxFramesExternalSort();
        int groupFrameLimit = physicalOptimizationConfig.getMaxFramesForGroupBy();
        int joinFrameLimit = physicalOptimizationConfig.getMaxFramesForJoin();
        int textSearchFrameLimit = physicalOptimizationConfig.getMaxFramesForTextSearch();
        List<PlanStage> planStages = ResourceUtils.getStages(plan);
        return ResourceUtils.getStageBasedRequiredCapacity(planStages, computationLocations.getLocations().length, sortFrameLimit, groupFrameLimit, joinFrameLimit, textSearchFrameLimit, frameSize);
    }

    public static List<PlanStage> getStages(ILogicalPlan plan) throws AlgebricksException {
        ILogicalOperator rootOp = (ILogicalOperator)((Mutable)plan.getRoots().get(0)).getValue();
        PlanStagesGenerator stagesGenerator = new PlanStagesGenerator();
        rootOp.accept((ILogicalOperatorVisitor)stagesGenerator, null);
        return stagesGenerator.getStages();
    }

    public static IClusterCapacity getStageBasedRequiredCapacity(List<PlanStage> stages, int computationLocations, int sortFrameLimit, int groupFrameLimit, int joinFrameLimit, int textSearchFrameLimit, int frameSize) {
        OperatorResourcesComputer computer = new OperatorResourcesComputer(computationLocations, sortFrameLimit, groupFrameLimit, joinFrameLimit, textSearchFrameLimit, frameSize);
        ClusterCapacity clusterCapacity = new ClusterCapacity();
        Long maxRequiredMemory = stages.stream().mapToLong(stage -> stage.getRequiredMemory(computer)).max().orElseThrow(IllegalStateException::new);
        clusterCapacity.setAggregatedMemoryByteSize(maxRequiredMemory.longValue());
        Integer maxRequireCores = stages.stream().mapToInt(stage -> stage.getRequiredCores(computer)).max().orElseThrow(IllegalStateException::new);
        clusterCapacity.setAggregatedCores(maxRequireCores.intValue());
        return clusterCapacity;
    }
}

