/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.utils;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.app.translator.QueryTranslator;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ExceptionUtils;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.dataflow.data.nontagged.MissingWriterFactory;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IActiveEntityController;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.rebalance.IDatasetRebalanceCallback;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import org.apache.hyracks.dataflow.std.connectors.MToNPartitioningConnectorDescriptor;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RebalanceUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private RebalanceUtil() {
    }

    public static void rebalance(String dataverseName, String datasetName, Set<String> targetNcNames, MetadataProvider metadataProvider, IHyracksClientConnection hcc, IDatasetRebalanceCallback datasetRebalanceCallback) throws Exception {
        Dataset targetDataset;
        Dataset sourceDataset;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            sourceDataset = metadataProvider.findDataset(dataverseName, datasetName);
            if (sourceDataset == null) {
                return;
            }
            HashSet sourceNodes = new HashSet(metadataProvider.findNodes(sourceDataset.getNodeGroupName()));
            if (sourceNodes.equals(targetNcNames)) {
                return;
            }
            if (!targetNcNames.isEmpty()) {
                String nodeGroupName = DatasetUtil.createNodeGroupForNewDataset((String)sourceDataset.getDataverseName(), (String)sourceDataset.getDatasetName(), (long)(sourceDataset.getRebalanceCount() + 1L), targetNcNames, (MetadataProvider)metadataProvider);
                targetDataset = sourceDataset.getTargetDatasetForRebalance(nodeGroupName);
                LOGGER.info("Rebalancing dataset {} from node group {} with nodes {} to node group {} with nodes {}", (Object)sourceDataset.getDatasetName(), (Object)sourceDataset.getNodeGroupName(), sourceNodes, (Object)targetDataset.getNodeGroupName(), targetNcNames);
                RebalanceUtil.rebalance(sourceDataset, targetDataset, metadataProvider, hcc, datasetRebalanceCallback);
            } else {
                targetDataset = null;
                RebalanceUtil.purgeDataset(sourceDataset, metadataProvider, hcc);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        if (targetNcNames.isEmpty()) {
            return;
        }
        RebalanceUtil.runWithRetryAfterInterrupt(() -> {
            RebalanceUtil.runMetadataTransaction(metadataProvider, () -> RebalanceUtil.rebalanceSwitch(sourceDataset, targetDataset, metadataProvider));
            RebalanceUtil.runMetadataTransaction(metadataProvider, () -> RebalanceUtil.dropSourceDataset(sourceDataset, metadataProvider, hcc));
        });
        LOGGER.info("Dataset {} rebalance completed successfully", (Object)datasetName);
    }

    private static void runWithRetryAfterInterrupt(Work work) throws Exception {
        int retryCount = 0;
        InterruptedException interruptedException = null;
        boolean done = false;
        do {
            try {
                work.run();
                done = true;
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof InterruptedException) {
                    interruptedException = (InterruptedException)rootCause;
                    Thread.interrupted();
                    LOGGER.log(Level.WARN, "Retry with attempt " + ++retryCount, (Throwable)e);
                    continue;
                }
                throw e;
            }
        } while (!done);
        if (interruptedException != null) {
            throw interruptedException;
        }
    }

    private static void runMetadataTransaction(MetadataProvider metadataProvider, Work work) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            work.run();
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    private static void rebalance(Dataset source, Dataset target, MetadataProvider metadataProvider, IHyracksClientConnection hcc, IDatasetRebalanceCallback datasetRebalanceCallback) throws Exception {
        RebalanceUtil.dropDatasetFiles(target, metadataProvider, hcc);
        datasetRebalanceCallback.beforeRebalance(metadataProvider, source, target, hcc);
        RebalanceUtil.createRebalanceTarget(target, metadataProvider, hcc);
        RebalanceUtil.populateDataToRebalanceTarget(source, target, metadataProvider, hcc);
        RebalanceUtil.createAndLoadSecondaryIndexesForTarget(source, target, metadataProvider, hcc);
        datasetRebalanceCallback.afterRebalance(metadataProvider, source, target, hcc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebalanceSwitch(Dataset source, Dataset target, MetadataProvider metadataProvider) throws AlgebricksException, RemoteException {
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        ActiveNotificationHandler activeNotificationHandler = (ActiveNotificationHandler)appCtx.getActiveNotificationHandler();
        IMetadataLockManager lockManager = appCtx.getMetadataLockManager();
        lockManager.upgradeDatasetLockToWrite(metadataProvider.getLocks(), DatasetUtil.getFullyQualifiedName((Dataset)source));
        LOGGER.info("Updating dataset {} node group from {} to {}", (Object)source.getDatasetName(), (Object)source.getNodeGroupName(), (Object)target.getNodeGroupName());
        try {
            MetadataManager.INSTANCE.updateDataset(mdTxnCtx, target);
            for (IActiveEntityEventsListener listener : activeNotificationHandler.getEventListeners()) {
                if (!(listener instanceof IActiveEntityController)) continue;
                IActiveEntityController controller = (IActiveEntityController)listener;
                controller.replace(target);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            LOGGER.info("dataset {} node group updated to {}", (Object)target.getDatasetName(), (Object)target.getNodeGroupName());
        }
        finally {
            lockManager.downgradeDatasetLockToExclusiveModify(metadataProvider.getLocks(), DatasetUtil.getFullyQualifiedName((Dataset)target));
        }
    }

    private static void dropSourceDataset(Dataset source, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        RebalanceUtil.dropDatasetFiles(source, metadataProvider, hcc);
        RebalanceUtil.tryDropDatasetNodegroup(source, metadataProvider);
        MetadataManager.INSTANCE.commitTransaction(metadataProvider.getMetadataTxnContext());
    }

    private static void tryDropDatasetNodegroup(Dataset source, MetadataProvider metadataProvider) throws Exception {
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        String sourceNodeGroup = source.getNodeGroupName();
        appCtx.getMetadataLockManager().acquireNodeGroupWriteLock(metadataProvider.getLocks(), sourceNodeGroup);
        MetadataManager.INSTANCE.dropNodegroup(metadataProvider.getMetadataTxnContext(), sourceNodeGroup, true);
    }

    private static void createRebalanceTarget(Dataset target, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        JobSpecification spec = DatasetUtil.createDatasetJobSpec((Dataset)target, (MetadataProvider)metadataProvider);
        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
    }

    private static void populateDataToRebalanceTarget(Dataset source, Dataset target, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        JobSpecification spec = new JobSpecification();
        TxnId txnId = metadataProvider.getTxnIdFactory().create();
        JobEventListenerFactory jobEventListenerFactory = new JobEventListenerFactory(txnId, true);
        spec.setJobletEventListenerFactory((IJobletEventListenerFactory)jobEventListenerFactory);
        IOperatorDescriptor starter = DatasetUtil.createDummyKeyProviderOp((JobSpecification)spec, (Dataset)source, (MetadataProvider)metadataProvider);
        IOperatorDescriptor primaryScanOp = DatasetUtil.createPrimaryIndexScanOp((JobSpecification)spec, (MetadataProvider)metadataProvider, (Dataset)source);
        IOperatorDescriptor upsertOp = RebalanceUtil.createPrimaryIndexUpsertOp(spec, metadataProvider, source, target);
        IOperatorDescriptor commitOp = RebalanceUtil.createUpsertCommitOp(spec, metadataProvider, target);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), starter, 0, primaryScanOp, 0);
        int numKeys = target.getPrimaryKeys().size();
        int[] keys = IntStream.range(0, numKeys).toArray();
        MToNPartitioningConnectorDescriptor connectorDescriptor = new MToNPartitioningConnectorDescriptor((IConnectorDescriptorRegistry)spec, (ITuplePartitionComputerFactory)new FieldHashPartitionComputerFactory(keys, target.getPrimaryHashFunctionFactories(metadataProvider)));
        spec.connect((IConnectorDescriptor)connectorDescriptor, primaryScanOp, 0, upsertOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), upsertOp, 0, commitOp, 0);
        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
    }

    private static IOperatorDescriptor createPrimaryIndexUpsertOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset source, Dataset target) throws AlgebricksException {
        int numKeys = source.getPrimaryKeys().size();
        int numValues = source.hasMetaPart() ? 2 : 1;
        int[] fieldPermutation = IntStream.range(0, numKeys + numValues).toArray();
        Pair upsertOpAndConstraints = DatasetUtil.createPrimaryIndexUpsertOp((JobSpecification)spec, (MetadataProvider)metadataProvider, (Dataset)target, (RecordDescriptor)source.getPrimaryRecordDescriptor(metadataProvider), (int[])fieldPermutation, (IMissingWriterFactory)MissingWriterFactory.INSTANCE);
        IOperatorDescriptor upsertOp = (IOperatorDescriptor)upsertOpAndConstraints.first;
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)upsertOp, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)upsertOpAndConstraints.second));
        return upsertOp;
    }

    private static IOperatorDescriptor createUpsertCommitOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset target) throws AlgebricksException {
        int[] primaryKeyFields = RebalanceUtil.getPrimaryKeyPermutationForUpsert(target);
        return new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{target.getCommitRuntimeFactory(metadataProvider, primaryKeyFields, true)}, new RecordDescriptor[]{target.getPrimaryRecordDescriptor(metadataProvider)});
    }

    private static void dropDatasetFiles(Dataset dataset, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        ArrayList<JobSpecification> jobs = new ArrayList<JobSpecification>();
        List indexes = metadataProvider.getDatasetIndexes(dataset.getDataverseName(), dataset.getDatasetName());
        for (Index index : indexes) {
            jobs.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)dataset, EnumSet.of(IndexDropOperatorDescriptor.DropOption.IF_EXISTS, IndexDropOperatorDescriptor.DropOption.WAIT_ON_IN_USE)));
        }
        for (JobSpecification jobSpec : jobs) {
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
        }
    }

    private static void createAndLoadSecondaryIndexesForTarget(Dataset source, Dataset target, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        for (Index index : metadataProvider.getDatasetIndexes(source.getDataverseName(), source.getDatasetName())) {
            if (!index.isSecondaryIndex()) continue;
            JobSpecification indexCreationJobSpec = IndexUtil.buildSecondaryIndexCreationJobSpec((Dataset)target, (Index)index, (MetadataProvider)metadataProvider);
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)indexCreationJobSpec, (boolean)true);
            JobSpecification indexLoadingJobSpec = IndexUtil.buildSecondaryIndexLoadingJobSpec((Dataset)target, (Index)index, (MetadataProvider)metadataProvider);
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)indexLoadingJobSpec, (boolean)true);
        }
    }

    private static int[] getPrimaryKeyPermutationForUpsert(Dataset dataset) {
        int numFilterFields;
        int f = 1;
        if (dataset.hasMetaPart()) {
            ++f;
        }
        int n = numFilterFields = DatasetUtil.getFilterField((Dataset)dataset) == null ? 0 : 1;
        if (numFilterFields > 0) {
            ++f;
        }
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        int[] pkIndexes = new int[numPrimaryKeys];
        for (int i = 0; i < pkIndexes.length; ++i) {
            pkIndexes[i] = f++;
        }
        return pkIndexes;
    }

    private static void purgeDataset(Dataset dataset, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        RebalanceUtil.runWithRetryAfterInterrupt(() -> {
            RebalanceUtil.dropDatasetFiles(dataset, metadataProvider, hcc);
            RebalanceUtil.runMetadataTransaction(metadataProvider, () -> MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataset.getDataverseName(), dataset.getDatasetName()));
            MetadataManager.INSTANCE.commitTransaction(metadataProvider.getMetadataTxnContext());
            RebalanceUtil.runMetadataTransaction(metadataProvider, () -> RebalanceUtil.tryDropDatasetNodegroup(dataset, metadataProvider));
            MetadataManager.INSTANCE.commitTransaction(metadataProvider.getMetadataTxnContext());
        });
    }

    @FunctionalInterface
    private static interface Work {
        public void run() throws Exception;
    }
}

