/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalRecoveryManager
implements IGlobalRecoveryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IStorageComponentProvider componentProvider;
    protected final ICCServiceContext serviceCtx;
    protected IHyracksClientConnection hcc;
    protected volatile boolean recoveryCompleted;
    protected volatile boolean recovering;

    public GlobalRecoveryManager(ICCServiceContext serviceCtx, IHyracksClientConnection hcc, IStorageComponentProvider componentProvider) {
        this.serviceCtx = serviceCtx;
        this.hcc = hcc;
        this.componentProvider = componentProvider;
    }

    public Set<IClusterManagementWork> notifyNodeFailure(Collection<String> deadNodeIds) {
        return Collections.emptySet();
    }

    public Set<IClusterManagementWork> notifyNodeJoin(String joinedNodeId) {
        return Collections.emptySet();
    }

    private void executeHyracksJob(JobSpecification spec) throws Exception {
        spec.setMaxReattempts(0);
        JobId jobId = this.hcc.startJob(spec);
        this.hcc.waitForCompletion(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGlobalRecovery(ICcApplicationContext appCtx) {
        if (!this.recoveryCompleted && !this.recovering) {
            GlobalRecoveryManager globalRecoveryManager = this;
            synchronized (globalRecoveryManager) {
                if (!this.recovering) {
                    this.recovering = true;
                    this.serviceCtx.getControllerService().getExecutor().submit(() -> {
                        try {
                            this.recover(appCtx);
                        }
                        catch (HyracksDataException e) {
                            LOGGER.log(Level.ERROR, "Global recovery failed. Shutting down...", (Throwable)e);
                            ExitUtil.exit((int)3);
                        }
                    });
                }
            }
        }
    }

    protected void recover(ICcApplicationContext appCtx) throws HyracksDataException {
        try {
            LOGGER.info("Starting Global Recovery");
            MetadataManager.INSTANCE.init();
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            mdTxnCtx = this.doRecovery(appCtx, mdTxnCtx);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            this.recoveryCompleted = true;
            this.recovering = false;
            LOGGER.info("Global Recovery Completed. Refreshing cluster state...");
            appCtx.getClusterStateManager().refreshState();
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected MetadataTransactionContext doRecovery(ICcApplicationContext appCtx, MetadataTransactionContext mdTxnCtx) throws Exception {
        for (Dataverse dataverse : MetadataManager.INSTANCE.getDataverses(mdTxnCtx)) {
            mdTxnCtx = this.recoverDataset(appCtx, mdTxnCtx, dataverse);
        }
        return mdTxnCtx;
    }

    public void notifyStateChange(IClusterManagementWork.ClusterState newState) {
        if (newState != IClusterManagementWork.ClusterState.ACTIVE && newState != IClusterManagementWork.ClusterState.RECOVERING) {
            this.recoveryCompleted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataTransactionContext recoverDataset(ICcApplicationContext appCtx, MetadataTransactionContext mdTxnCtx, Dataverse dataverse) throws Exception {
        if (!dataverse.getDataverseName().equals("Metadata")) {
            MetadataProvider metadataProvider = new MetadataProvider(appCtx, dataverse);
            try {
                List datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverse.getDataverseName());
                for (Dataset dataset : datasets) {
                    List files;
                    if (dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) continue;
                    List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName());
                    ExternalDatasetDetails dsd = (ExternalDatasetDetails)dataset.getDatasetDetails();
                    DatasetConfig.TransactionState datasetState = dsd.getState();
                    if (!indexes.isEmpty()) {
                        if (datasetState == DatasetConfig.TransactionState.BEGIN) {
                            files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
                            for (ExternalFile file : files) {
                                if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                            }
                        }
                        metadataProvider.setMetadataTxnContext(mdTxnCtx);
                        JobSpecification jobSpec = ExternalIndexingOperations.buildAbortOp((Dataset)dataset, (List)indexes, (MetadataProvider)metadataProvider);
                        this.executeHyracksJob(jobSpec);
                        ((ExternalDatasetDetails)dataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                        MetadataManager.INSTANCE.updateDataset(mdTxnCtx, dataset);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                        continue;
                    }
                    if (datasetState != DatasetConfig.TransactionState.READY_TO_COMMIT) continue;
                    files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    JobSpecification jobSpec = ExternalIndexingOperations.buildRecoverOp((Dataset)dataset, (List)indexes, (MetadataProvider)metadataProvider);
                    this.executeHyracksJob(jobSpec);
                    for (ExternalFile file : files) {
                        if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.ADD_OP) {
                            MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                            file.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                            MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                        } else if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.DROP_OP) {
                            for (ExternalFile originalFile : files) {
                                if (!originalFile.getFileName().equals(file.getFileName())) continue;
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, originalFile);
                                break;
                            }
                        } else if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.APPEND_OP) {
                            for (ExternalFile originalFile : files) {
                                if (!originalFile.getFileName().equals(file.getFileName())) continue;
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, originalFile);
                                originalFile.setSize(file.getSize());
                                MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, originalFile);
                            }
                        }
                        ((ExternalDatasetDetails)dataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                        MetadataManager.INSTANCE.updateDataset(mdTxnCtx, dataset);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    }
                }
            }
            finally {
                metadataProvider.getLocks().unlock();
            }
        }
        return mdTxnCtx;
    }

    public boolean isRecoveryCompleted() {
        return this.recoveryCompleted;
    }
}

