/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.result;

import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.job.JobId;

public class ResultHandle {
    private final JobId jobId;
    private final ResultSetId resultSetId;

    public ResultHandle(JobId jobId, ResultSetId resultSetId) {
        this.jobId = jobId;
        this.resultSetId = resultSetId;
    }

    public ResultHandle(long jobId, long resultSetId) {
        this(new JobId(jobId), new ResultSetId(resultSetId));
    }

    public static ResultHandle parse(String str) {
        int dash = str.indexOf(45);
        if (dash < 1) {
            return null;
        }
        int start = 0;
        while (str.charAt(start) == '/') {
            ++start;
        }
        String jobIdStr = str.substring(start, dash);
        String resIdStr = str.substring(dash + 1);
        try {
            return new ResultHandle(Long.parseLong(jobIdStr), Long.parseLong(resIdStr));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public ResultSetId getResultSetId() {
        return this.resultSetId;
    }

    public String toString() {
        return Long.toString(this.jobId.getId()) + "-" + Long.toString(this.resultSetId.getId());
    }
}

