/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.storage.IReplicaManager;
import org.apache.asterix.common.storage.ReplicaIdentifier;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicaManager
implements IReplicaManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INcApplicationContext appCtx;
    private final Set<Integer> partitions = new HashSet<Integer>();
    private final Map<ReplicaIdentifier, PartitionReplica> replicas = new HashMap<ReplicaIdentifier, PartitionReplica>();
    private final Object replicaSyncLock = new Object();

    public ReplicaManager(INcApplicationContext appCtx, Set<Integer> partitions) {
        this.appCtx = appCtx;
        this.partitions.addAll(partitions);
    }

    public synchronized void addReplica(ReplicaIdentifier id) {
        if (!this.partitions.contains(id.getPartition())) {
            throw new IllegalStateException("This node is not the current master of partition(" + id.getPartition() + ")");
        }
        if (this.isSelf(id)) {
            LOGGER.info("ignoring request to add replica to ourselves");
            return;
        }
        this.replicas.computeIfAbsent(id, k -> new PartitionReplica(k, this.appCtx));
        this.replicas.get(id).sync();
    }

    public synchronized void removeReplica(ReplicaIdentifier id) {
        if (!this.replicas.containsKey(id)) {
            throw new IllegalStateException("replica with id(" + id + ") does not exist");
        }
        PartitionReplica replica = this.replicas.remove(id);
        this.appCtx.getReplicationManager().unregister((IPartitionReplica)replica);
    }

    public synchronized List<IPartitionReplica> getReplicas(int partition) {
        return this.replicas.entrySet().stream().filter(e -> ((ReplicaIdentifier)e.getKey()).getPartition() == partition).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public synchronized Set<Integer> getPartitions() {
        return Collections.unmodifiableSet(this.partitions);
    }

    public synchronized void promote(int partition) throws HyracksDataException {
        if (this.partitions.contains(partition)) {
            return;
        }
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
        localResourceRepository.cleanup(partition);
        IRecoveryManager recoveryManager = this.appCtx.getTransactionSubsystem().getRecoveryManager();
        recoveryManager.replayReplicaPartitionLogs(Stream.of(Integer.valueOf(partition)).collect(Collectors.toSet()), true);
        this.partitions.add(partition);
    }

    public synchronized void release(int partition) throws HyracksDataException {
        if (!this.partitions.contains(partition)) {
            return;
        }
        IDatasetLifecycleManager datasetLifecycleManager = this.appCtx.getDatasetLifecycleManager();
        datasetLifecycleManager.flushDataset(this.appCtx.getReplicationManager().getReplicationStrategy());
        this.closePartitionResources(partition);
        List<IPartitionReplica> partitionReplicas = this.getReplicas(partition);
        for (IPartitionReplica replica : partitionReplicas) {
            this.appCtx.getReplicationManager().unregister(replica);
        }
        this.partitions.remove(partition);
    }

    public Object getReplicaSyncLock() {
        return this.replicaSyncLock;
    }

    private void closePartitionResources(int partition) throws HyracksDataException {
        PersistentLocalResourceRepository resourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
        Map partitionResources = resourceRepository.getPartitionResources(partition);
        IDatasetLifecycleManager datasetLifecycleManager = this.appCtx.getDatasetLifecycleManager();
        for (LocalResource resource : partitionResources.values()) {
            datasetLifecycleManager.close(resource.getPath());
        }
    }

    private boolean isSelf(ReplicaIdentifier id) {
        IApplicationConfig appConfig = this.appCtx.getServiceContext().getAppConfig();
        String host = appConfig.getString((IOption)NCConfig.Option.REPLICATION_LISTEN_ADDRESS);
        int port = appConfig.getInt((IOption)NCConfig.Option.REPLICATION_LISTEN_PORT);
        InetSocketAddress replicaAddress = new InetSocketAddress(host, port);
        return id.equals((Object)ReplicaIdentifier.of((int)id.getPartition(), (InetSocketAddress)replicaAddress));
    }
}

