/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.asterix.common.storage.DatasetResourceReference;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.common.transactions.Checkpoint;
import org.apache.asterix.common.transactions.ICheckpointManager;
import org.apache.asterix.common.transactions.ILogReader;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.asterix.transaction.management.service.recovery.TxnEntityId;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecoveryManager
implements IRecoveryManager,
ILifeCycleComponent {
    public static final boolean IS_DEBUG_MODE = false;
    private static final long SMALLEST_POSSIBLE_LSN = 0L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final ITransactionSubsystem txnSubsystem;
    private final org.apache.asterix.transaction.management.service.logging.LogManager logMgr;
    private final boolean replicationEnabled;
    private static final String RECOVERY_FILES_DIR_NAME = "recovery_temp";
    private Map<Long, JobEntityCommits> jobId2WinnerEntitiesMap = null;
    private final long cachedEntityCommitsPerJobSize;
    private final PersistentLocalResourceRepository localResourceRepository;
    private final ICheckpointManager checkpointManager;
    private IRecoveryManager.SystemState state;
    private final INCServiceContext serviceCtx;
    private final INcApplicationContext appCtx;
    private static final TxnId recoveryTxnId = new TxnId(-1L);

    public RecoveryManager(ITransactionSubsystem txnSubsystem, INCServiceContext serviceCtx) {
        this.serviceCtx = serviceCtx;
        this.txnSubsystem = txnSubsystem;
        this.appCtx = txnSubsystem.getApplicationContext();
        this.logMgr = (org.apache.asterix.transaction.management.service.logging.LogManager)txnSubsystem.getLogManager();
        ReplicationProperties repProperties = this.appCtx.getReplicationProperties();
        this.replicationEnabled = repProperties.isReplicationEnabled();
        this.localResourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
        this.cachedEntityCommitsPerJobSize = txnSubsystem.getTransactionProperties().getJobRecoveryMemorySize();
        this.checkpointManager = txnSubsystem.getCheckpointManager();
    }

    public IRecoveryManager.SystemState getSystemState() throws ACIDException {
        Checkpoint checkpointObject = this.checkpointManager.getLatest();
        if (checkpointObject == null) {
            this.state = IRecoveryManager.SystemState.PERMANENT_DATA_LOSS;
            LOGGER.info("The checkpoint file doesn't exist: systemState = PERMANENT_DATA_LOSS");
            return this.state;
        }
        long readableSmallestLSN = this.logMgr.getReadableSmallestLSN();
        if (this.logMgr.getAppendLSN() == readableSmallestLSN) {
            if (checkpointObject.getMinMCTFirstLsn() != -1L) {
                LOGGER.warn("Some(or all) of transaction log files are lost.");
            }
            this.state = IRecoveryManager.SystemState.HEALTHY;
        } else {
            this.state = checkpointObject.getCheckpointLsn() == this.logMgr.getAppendLSN() && checkpointObject.getMinMCTFirstLsn() == -1L ? IRecoveryManager.SystemState.HEALTHY : IRecoveryManager.SystemState.CORRUPTED;
        }
        return this.state;
    }

    public void startLocalRecovery(Set<Integer> partitions) throws IOException, ACIDException {
        this.state = IRecoveryManager.SystemState.RECOVERING;
        LOGGER.info("starting recovery ...");
        long readableSmallestLSN = this.logMgr.getReadableSmallestLSN();
        Checkpoint checkpointObject = this.checkpointManager.getLatest();
        long lowWaterMarkLSN = checkpointObject.getMinMCTFirstLsn();
        if (lowWaterMarkLSN < readableSmallestLSN) {
            lowWaterMarkLSN = readableSmallestLSN;
        }
        this.deleteRecoveryTemporaryFiles();
        this.replayPartitionsLogs(partitions, this.logMgr.getLogReader(true), lowWaterMarkLSN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replayPartitionsLogs(Set<Integer> partitions, ILogReader logReader, long lowWaterMarkLSN) throws IOException, ACIDException {
        try {
            Set<Long> winnerJobSet = this.startRecoverysAnalysisPhase(partitions, logReader, lowWaterMarkLSN);
            this.startRecoveryRedoPhase(partitions, logReader, lowWaterMarkLSN, winnerJobSet);
        }
        finally {
            logReader.close();
            this.deleteRecoveryTemporaryFiles();
        }
    }

    private synchronized Set<Long> startRecoverysAnalysisPhase(Set<Integer> partitions, ILogReader logReader, long lowWaterMarkLSN) throws IOException, ACIDException {
        int updateLogCount = 0;
        int entityCommitLogCount = 0;
        int jobCommitLogCount = 0;
        int abortLogCount = 0;
        HashSet<Long> winnerJobSet = new HashSet<Long>();
        this.jobId2WinnerEntitiesMap = new HashMap<Long, JobEntityCommits>();
        logReader.setPosition(lowWaterMarkLSN);
        ILogRecord logRecord = logReader.next();
        while (logRecord != null) {
            switch (logRecord.getLogType()) {
                case 0: {
                    if (!partitions.contains(logRecord.getResourcePartition())) break;
                    ++updateLogCount;
                    break;
                }
                case 1: {
                    winnerJobSet.add(logRecord.getTxnId());
                    this.cleanupTxnCommits(logRecord.getTxnId());
                    ++jobCommitLogCount;
                    break;
                }
                case 2: {
                    if (!partitions.contains(logRecord.getResourcePartition())) break;
                    this.analyzeEntityCommitLog(logRecord);
                    ++entityCommitLogCount;
                    break;
                }
                case 3: {
                    ++abortLogCount;
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    throw new ACIDException("Unsupported LogType: " + logRecord.getLogType());
                }
            }
            logRecord = logReader.next();
        }
        for (JobEntityCommits winners : this.jobId2WinnerEntitiesMap.values()) {
            winners.prepareForSearch();
        }
        LOGGER.info("Logs analysis phase completed.");
        LOGGER.info("Analysis log count update/entityCommit/jobCommit/abort = " + updateLogCount + "/" + entityCommitLogCount + "/" + jobCommitLogCount + "/" + abortLogCount);
        return winnerJobSet;
    }

    private void cleanupTxnCommits(long txnId) {
        if (this.jobId2WinnerEntitiesMap.containsKey(txnId)) {
            JobEntityCommits jobEntityWinners = this.jobId2WinnerEntitiesMap.get(txnId);
            jobEntityWinners.clear();
            this.jobId2WinnerEntitiesMap.remove(txnId);
        }
    }

    private void analyzeEntityCommitLog(ILogRecord logRecord) throws IOException {
        JobEntityCommits jobEntityWinners;
        long txnId = logRecord.getTxnId();
        if (!this.jobId2WinnerEntitiesMap.containsKey(txnId)) {
            jobEntityWinners = new JobEntityCommits(txnId);
            if (this.needToFreeMemory()) {
                this.freeJobsCachedEntities(txnId);
            }
            this.jobId2WinnerEntitiesMap.put(txnId, jobEntityWinners);
        } else {
            jobEntityWinners = this.jobId2WinnerEntitiesMap.get(txnId);
        }
        jobEntityWinners.add(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startRecoveryRedoPhase(Set<Integer> partitions, ILogReader logReader, long lowWaterMarkLSN, Set<Long> winnerTxnSet) throws IOException, ACIDException {
        int redoCount = 0;
        long txnId = 0L;
        long lsn = -1L;
        ILSMIndex index = null;
        LocalResource localResource = null;
        DatasetLocalResource localResourceMetadata = null;
        boolean foundWinner = false;
        JobEntityCommits jobEntityWinners = null;
        IDatasetLifecycleManager datasetLifecycleManager = this.appCtx.getDatasetLifecycleManager();
        IIndexCheckpointManagerProvider indexCheckpointManagerProvider = ((INcApplicationContext)this.serviceCtx.getApplicationContext()).getIndexCheckpointManagerProvider();
        Map resourcesMap = this.localResourceRepository.loadAndGetAllResources();
        HashMap<Long, Long> resourceId2MaxLSNMap = new HashMap<Long, Long>();
        TxnEntityId tempKeyTxnEntityId = new TxnEntityId(-1L, -1, -1, null, -1, false);
        ILogRecord logRecord = null;
        ILSMComponentIdGenerator idGenerator = null;
        try {
            logReader.setPosition(lowWaterMarkLSN);
            logRecord = logReader.next();
            block11: while (logRecord != null) {
                lsn = logRecord.getLSN();
                txnId = logRecord.getTxnId();
                foundWinner = false;
                switch (logRecord.getLogType()) {
                    case 0: {
                        if (partitions.contains(logRecord.getResourcePartition())) {
                            if (winnerTxnSet.contains(txnId)) {
                                foundWinner = true;
                            } else if (this.jobId2WinnerEntitiesMap.containsKey(txnId)) {
                                jobEntityWinners = this.jobId2WinnerEntitiesMap.get(txnId);
                                tempKeyTxnEntityId.setTxnId(txnId, logRecord.getDatasetId(), logRecord.getPKHashValue(), logRecord.getPKValue(), logRecord.getPKValueSize());
                                if (jobEntityWinners.containsEntityCommitForTxnId(lsn, tempKeyTxnEntityId)) {
                                    foundWinner = true;
                                }
                            }
                            if (!foundWinner) break;
                        }
                    }
                    case 7: {
                        long maxDiskLastLsn;
                        if (!partitions.contains(logRecord.getResourcePartition())) break;
                        long resourceId = logRecord.getResourceId();
                        localResource = (LocalResource)resourcesMap.get(resourceId);
                        if (localResource == null) {
                            LOGGER.log(Level.WARN, "resource was not found for resource id " + resourceId);
                            logRecord = logReader.next();
                            continue block11;
                        }
                        localResourceMetadata = (DatasetLocalResource)localResource.getResource();
                        index = (ILSMIndex)datasetLifecycleManager.get(localResource.getPath());
                        if (index == null) {
                            index = (ILSMIndex)localResourceMetadata.createInstance(this.serviceCtx);
                            datasetLifecycleManager.register(localResource.getPath(), (Object)index);
                            datasetLifecycleManager.open(localResource.getPath());
                            try {
                                DatasetResourceReference resourceReference = DatasetResourceReference.of((LocalResource)localResource);
                                maxDiskLastLsn = indexCheckpointManagerProvider.get((ResourceReference)resourceReference).getLowWatermark();
                            }
                            catch (HyracksDataException e) {
                                datasetLifecycleManager.close(localResource.getPath());
                                throw e;
                            }
                            resourceId2MaxLSNMap.put(resourceId, maxDiskLastLsn);
                        } else {
                            maxDiskLastLsn = (Long)resourceId2MaxLSNMap.get(resourceId);
                        }
                        if (lsn < maxDiskLastLsn) break;
                        RecoveryManager.redo(logRecord, datasetLifecycleManager);
                        ++redoCount;
                        break;
                    }
                    case 4: {
                        long maxDiskLastLsn;
                        int partition = logRecord.getResourcePartition();
                        if (!partitions.contains(partition)) break;
                        int datasetId = logRecord.getDatasetId();
                        idGenerator = datasetLifecycleManager.getComponentIdGenerator(datasetId, partition);
                        if (idGenerator == null) {
                            logRecord = logReader.next();
                            continue block11;
                        }
                        idGenerator.refresh();
                        DatasetInfo dsInfo = datasetLifecycleManager.getDatasetInfo(datasetId);
                        for (IndexInfo iInfo : dsInfo.getIndexes().values()) {
                            if (!iInfo.isOpen() || iInfo.getPartition() != partition) continue;
                            maxDiskLastLsn = (Long)resourceId2MaxLSNMap.get(iInfo.getResourceId());
                            index = iInfo.getIndex();
                            AbstractLSMIOOperationCallback ioCallback = (AbstractLSMIOOperationCallback)index.getIOOperationCallback();
                            if (logRecord.getLSN() > maxDiskLastLsn && !index.isCurrentMutableComponentEmpty()) {
                                ioCallback.updateLastLSN(logRecord.getLSN());
                                RecoveryManager.redoFlush(index, logRecord);
                                ++redoCount;
                                continue;
                            }
                            if (index.isMemoryComponentsAllocated()) {
                                index.getCurrentMemoryComponent().resetId(idGenerator.getId(), true);
                                continue;
                            }
                            ioCallback.forceRefreshNextId();
                        }
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 8: {
                        break;
                    }
                    default: {
                        throw new ACIDException("Unsupported LogType: " + logRecord.getLogType());
                    }
                }
                logRecord = logReader.next();
            }
            LOGGER.info("Logs REDO phase completed. Redo logs count: " + redoCount);
        }
        finally {
            this.txnSubsystem.getTransactionManager().ensureMaxTxnId(txnId);
            Set resourceIdList = resourceId2MaxLSNMap.keySet();
            Iterator iterator = resourceIdList.iterator();
            while (iterator.hasNext()) {
                long r = (Long)iterator.next();
                datasetLifecycleManager.close(((LocalResource)resourcesMap.get(r)).getPath());
            }
        }
    }

    private boolean needToFreeMemory() {
        return Runtime.getRuntime().freeMemory() < this.cachedEntityCommitsPerJobSize;
    }

    public long getMinFirstLSN() throws HyracksDataException {
        long minFirstLSN = this.getLocalMinFirstLSN();
        if (this.replicationEnabled) {
            long remoteMinFirstLSN = this.getRemoteMinFirstLSN();
            minFirstLSN = Math.min(minFirstLSN, remoteMinFirstLSN);
        }
        return minFirstLSN;
    }

    public long getLocalMinFirstLSN() throws HyracksDataException {
        IDatasetLifecycleManager datasetLifecycleManager = this.appCtx.getDatasetLifecycleManager();
        List openIndexList = datasetLifecycleManager.getOpenResources();
        long minFirstLSN = this.logMgr.getAppendLSN();
        if (!openIndexList.isEmpty()) {
            for (IIndex index : openIndexList) {
                AbstractLSMIOOperationCallback ioCallback = (AbstractLSMIOOperationCallback)((ILSMIndex)index).getIOOperationCallback();
                if (((AbstractLSMIndex)index).isCurrentMutableComponentEmpty() && !ioCallback.hasPendingFlush()) continue;
                long firstLSN = ioCallback.getFirstLSN();
                minFirstLSN = Math.min(minFirstLSN, firstLSN);
            }
        }
        return minFirstLSN;
    }

    private long getRemoteMinFirstLSN() throws HyracksDataException {
        Set allPartitions = this.localResourceRepository.getAllPartitions();
        Set masterPartitions = this.appCtx.getReplicaManager().getPartitions();
        allPartitions.removeAll(masterPartitions);
        return this.getPartitionsMinLSN(allPartitions);
    }

    private long getPartitionsMinLSN(Set<Integer> partitions) throws HyracksDataException {
        IIndexCheckpointManagerProvider idxCheckpointMgrProvider = this.appCtx.getIndexCheckpointManagerProvider();
        long minRemoteLSN = Long.MAX_VALUE;
        for (Integer partition : partitions) {
            List partitionResources = this.localResourceRepository.getResources(resource -> {
                DatasetLocalResource dsResource = (DatasetLocalResource)resource.getResource();
                return dsResource.getPartition() == partition.intValue();
            }).values().stream().map(DatasetResourceReference::of).collect(Collectors.toList());
            for (DatasetResourceReference indexRef : partitionResources) {
                try {
                    IIndexCheckpointManager idxCheckpointMgr = idxCheckpointMgrProvider.get((ResourceReference)indexRef);
                    if (idxCheckpointMgr.getCheckpointCount() <= 0) continue;
                    long remoteIndexMaxLSN = idxCheckpointMgrProvider.get((ResourceReference)indexRef).getLowWatermark();
                    minRemoteLSN = Math.min(minRemoteLSN, remoteIndexMaxLSN);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to get min LSN of resource {}", (Object)indexRef, (Object)e);
                    return 0L;
                }
            }
        }
        return minRemoteLSN;
    }

    public synchronized void replayReplicaPartitionLogs(Set<Integer> partitions, boolean flush) throws HyracksDataException {
        try {
            this.checkpointManager.secure(recoveryTxnId);
            long minLSN = this.getPartitionsMinLSN(partitions);
            long readableSmallestLSN = this.logMgr.getReadableSmallestLSN();
            if (minLSN < readableSmallestLSN) {
                minLSN = readableSmallestLSN;
            }
            this.replayPartitionsLogs(partitions, this.logMgr.getLogReader(true), minLSN);
            if (flush) {
                this.appCtx.getDatasetLifecycleManager().flushAllDatasets();
            }
        }
        catch (IOException | ACIDException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.checkpointManager.completed(recoveryTxnId);
        }
    }

    public File createJobRecoveryFile(long txnId, String fileName) throws IOException {
        File jobRecoveryFile;
        String recoveryDirPath = this.getRecoveryDirPath();
        Path jobRecoveryFolder = Paths.get(recoveryDirPath + File.separator + txnId, new String[0]);
        if (!Files.exists(jobRecoveryFolder, new LinkOption[0])) {
            Files.createDirectories(jobRecoveryFolder, new FileAttribute[0]);
        }
        if (!(jobRecoveryFile = new File(jobRecoveryFolder.toString() + File.separator + fileName)).exists()) {
            if (!jobRecoveryFile.createNewFile()) {
                throw new IOException("Failed to create file: " + fileName + " for txn id(" + txnId + ")");
            }
        } else {
            throw new IOException("File: " + fileName + " for txn id(" + txnId + ") already exists");
        }
        return jobRecoveryFile;
    }

    public void deleteRecoveryTemporaryFiles() {
        String recoveryDirPath = this.getRecoveryDirPath();
        Path recoveryFolderPath = Paths.get(recoveryDirPath, new String[0]);
        FileUtils.deleteQuietly((File)recoveryFolderPath.toFile());
    }

    private String getRecoveryDirPath() {
        String logDir = this.logMgr.getLogManagerProperties().getLogDir();
        if (!logDir.endsWith(File.separator)) {
            logDir = logDir + File.separator;
        }
        return logDir + RECOVERY_FILES_DIR_NAME;
    }

    private void freeJobsCachedEntities(long requestingTxnId) throws IOException {
        if (this.jobId2WinnerEntitiesMap != null) {
            for (Map.Entry<Long, JobEntityCommits> jobEntityCommits : this.jobId2WinnerEntitiesMap.entrySet()) {
                if (jobEntityCommits.getKey() == requestingTxnId) continue;
                jobEntityCommits.getValue().spillToDiskAndfreeMemory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(ITransactionContext txnContext) throws ACIDException {
        long abortedTxnId = txnContext.getTxnId().getId();
        long firstLSN = txnContext.getFirstLSN();
        try {
            long localMinFirstLSN = this.getLocalMinFirstLSN();
            firstLSN = Math.max(firstLSN, localMinFirstLSN);
        }
        catch (HyracksDataException e) {
            throw new ACIDException((Throwable)e);
        }
        long lastLSN = txnContext.getLastLSN();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("rollbacking transaction log records from " + firstLSN + " to " + lastLSN);
        }
        if (firstLSN == -1L || firstLSN > lastLSN) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("no need to roll back as there were no operations by the txn " + txnContext.getTxnId());
            }
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("collecting loser transaction's LSNs from " + firstLSN + " to " + lastLSN);
        }
        HashMap<TxnEntityId, LinkedList<Long>> jobLoserEntity2LSNsMap = new HashMap<TxnEntityId, LinkedList<Long>>();
        TxnEntityId tempKeyTxnEntityId = new TxnEntityId(-1L, -1, -1, null, -1, false);
        int updateLogCount = 0;
        int entityCommitLogCount = 0;
        long currentLSN = -1L;
        List<Long> undoLSNSet = null;
        Set activePartitions = this.appCtx.getReplicaManager().getPartitions();
        try (ILogReader logReader = this.logMgr.getLogReader(false);){
            logReader.setPosition(firstLSN);
            ILogRecord logRecord = null;
            block11: while (currentLSN < lastLSN && (logRecord = logReader.next()) != null) {
                currentLSN = logRecord.getLSN();
                long logTxnId = logRecord.getTxnId();
                if (logTxnId != abortedTxnId) continue;
                tempKeyTxnEntityId.setTxnId(logTxnId, logRecord.getDatasetId(), logRecord.getPKHashValue(), logRecord.getPKValue(), logRecord.getPKValueSize());
                switch (logRecord.getLogType()) {
                    case 0: {
                        if (!activePartitions.contains(logRecord.getResourcePartition())) continue block11;
                        undoLSNSet = (List)jobLoserEntity2LSNsMap.get(tempKeyTxnEntityId);
                        if (undoLSNSet == null) {
                            TxnEntityId loserEntity = new TxnEntityId(logTxnId, logRecord.getDatasetId(), logRecord.getPKHashValue(), logRecord.getPKValue(), logRecord.getPKValueSize(), true);
                            undoLSNSet = new LinkedList<Long>();
                            jobLoserEntity2LSNsMap.put(loserEntity, (LinkedList<Long>)undoLSNSet);
                        }
                        undoLSNSet.add(currentLSN);
                        ++updateLogCount;
                        continue block11;
                    }
                    case 2: {
                        if (!activePartitions.contains(logRecord.getResourcePartition())) continue block11;
                        jobLoserEntity2LSNsMap.remove(tempKeyTxnEntityId);
                        ++entityCommitLogCount;
                        continue block11;
                    }
                    case 1: {
                        throw new ACIDException("Unexpected LogType(" + logRecord.getLogType() + ") during abort.");
                    }
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: {
                        continue block11;
                    }
                }
                throw new ACIDException("Unsupported LogType: " + logRecord.getLogType());
            }
            if (currentLSN != lastLSN) {
                throw new ACIDException("LastLSN mismatch: lastLSN(" + lastLSN + ") vs currentLSN(" + currentLSN + ") during abort( " + txnContext.getTxnId() + ")");
            }
            LOGGER.log(Level.INFO, "undoing loser transaction's effect");
            IDatasetLifecycleManager datasetLifecycleManager = this.appCtx.getDatasetLifecycleManager();
            Iterator iter = jobLoserEntity2LSNsMap.entrySet().iterator();
            int undoCount = 0;
            while (iter.hasNext()) {
                Map.Entry loserEntity2LSNsMap = iter.next();
                undoLSNSet = (LinkedList<Long>)loserEntity2LSNsMap.getValue();
                Collections.reverse(undoLSNSet);
                Iterator iterator = undoLSNSet.iterator();
                while (iterator.hasNext()) {
                    long undoLSN = (Long)iterator.next();
                    logRecord = logReader.read(undoLSN);
                    if (logRecord == null) {
                        throw new ACIDException("IllegalState exception during abort( " + txnContext.getTxnId() + ")");
                    }
                    RecoveryManager.undo(logRecord, datasetLifecycleManager);
                    ++undoCount;
                }
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("undone loser transaction's effect");
                LOGGER.info("[RecoveryManager's rollback log count] update/entityCommit/undo:" + updateLogCount + "/" + entityCommitLogCount + "/" + undoCount);
            }
        }
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream os) throws IOException {
    }

    public void dumpState(OutputStream os) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void undo(ILogRecord logRecord, IDatasetLifecycleManager datasetLifecycleManager) {
        try {
            ILSMIndex index = (ILSMIndex)datasetLifecycleManager.getIndex(logRecord.getDatasetId(), logRecord.getResourceId());
            ILSMIndexAccessor indexAccessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            try {
                switch (logRecord.getNewOp()) {
                    case 1: {
                        indexAccessor.forceDelete(logRecord.getNewValue());
                        return;
                    }
                    case 2: 
                    case 3: {
                        RecoveryManager.undoUpsertOrDelete(indexAccessor, logRecord);
                        return;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported OperationType: " + logRecord.getNewOp());
                    }
                }
            }
            finally {
                indexAccessor.destroy();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to undo", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void undoUpsertOrDelete(ILSMIndexAccessor indexAccessor, ILogRecord logRecord) throws HyracksDataException {
        if (logRecord.getOldValue() == null) {
            try {
                indexAccessor.forcePhysicalDelete(logRecord.getNewValue());
                return;
            }
            catch (HyracksDataException hde) {
                if (hde.getErrorCode() == 37) return;
                throw hde;
            }
        } else {
            indexAccessor.forceUpsert(logRecord.getOldValue());
        }
    }

    private static void redo(ILogRecord logRecord, IDatasetLifecycleManager datasetLifecycleManager) {
        block6: {
            try {
                int datasetId = logRecord.getDatasetId();
                long resourceId = logRecord.getResourceId();
                ILSMIndex index = (ILSMIndex)datasetLifecycleManager.getIndex(datasetId, resourceId);
                ILSMIndexAccessor indexAccessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                ILSMIndexOperationContext opCtx = indexAccessor.getOpContext();
                opCtx.setFilterSkip(true);
                opCtx.setRecovery(true);
                if (logRecord.getNewOp() == 1) {
                    indexAccessor.forceInsert(logRecord.getNewValue());
                    break block6;
                }
                if (logRecord.getNewOp() == 2) {
                    indexAccessor.forceDelete(logRecord.getNewValue());
                    break block6;
                }
                if (logRecord.getNewOp() == 3) {
                    indexAccessor.forceUpsert(logRecord.getNewValue());
                    break block6;
                }
                if (logRecord.getNewOp() == 4) {
                    opCtx.setFilterSkip(false);
                    indexAccessor.updateFilter(logRecord.getNewValue());
                    break block6;
                }
                throw new IllegalStateException("Unsupported OperationType: " + logRecord.getNewOp());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to redo", e);
            }
        }
    }

    private static void redoFlush(ILSMIndex index, ILogRecord logRecord) throws HyracksDataException {
        ILSMDiskComponent diskComponent;
        ILSMComponentId maxDiskComponentId;
        ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        long minId = logRecord.getFlushingComponentMinId();
        long maxId = logRecord.getFlushingComponentMaxId();
        LSMComponentId id = new LSMComponentId(minId, maxId);
        if (!index.getDiskComponents().isEmpty() && (maxDiskComponentId = (diskComponent = (ILSMDiskComponent)index.getDiskComponents().get(0)).getId()).compareTo((ILSMComponentId)id) != ILSMComponentId.IdCompareResult.LESS_THAN) {
            throw new IllegalStateException("Illegal state of component Id. Max disk component Id " + maxDiskComponentId + " should be less than redo flush component Id " + id);
        }
        index.getCurrentMemoryComponent().resetId((ILSMComponentId)id, true);
        accessor.scheduleFlush(index.getIOOperationCallback());
    }

    private class JobEntityCommits {
        private static final String PARTITION_FILE_NAME_SEPARATOR = "_";
        private final long txnId;
        private final Set<TxnEntityId> cachedEntityCommitTxns = new HashSet<TxnEntityId>();
        private final List<File> jobEntitCommitOnDiskPartitionsFiles = new ArrayList<File>();
        private boolean preparedForSearch = false;
        private TxnEntityId winnerEntity = null;
        private int currentPartitionSize = 0;
        private long partitionMaxLSN = 0L;
        private String currentPartitonName;

        public JobEntityCommits(long txnId) {
            this.txnId = txnId;
        }

        public void add(ILogRecord logRecord) throws IOException {
            if (this.preparedForSearch) {
                throw new IOException("Cannot add new entity commits after preparing for search.");
            }
            this.winnerEntity = new TxnEntityId(logRecord.getTxnId(), logRecord.getDatasetId(), logRecord.getPKHashValue(), logRecord.getPKValue(), logRecord.getPKValueSize(), true);
            this.cachedEntityCommitTxns.add(this.winnerEntity);
            this.partitionMaxLSN = logRecord.getLSN();
            this.currentPartitionSize += this.winnerEntity.getCurrentSize();
            if ((long)this.currentPartitionSize >= RecoveryManager.this.cachedEntityCommitsPerJobSize) {
                this.spillToDiskAndfreeMemory();
            }
        }

        public void spillToDiskAndfreeMemory() throws IOException {
            if (this.cachedEntityCommitTxns.size() > 0) {
                if (!this.preparedForSearch) {
                    this.writeCurrentPartitionToDisk();
                }
                this.cachedEntityCommitTxns.clear();
                this.partitionMaxLSN = 0L;
                this.currentPartitionSize = 0;
                this.currentPartitonName = "";
            }
        }

        public void prepareForSearch() throws IOException {
            if (this.jobEntitCommitOnDiskPartitionsFiles.size() > 0) {
                this.spillToDiskAndfreeMemory();
            } else {
                this.currentPartitonName = this.getPartitionName(this.partitionMaxLSN);
            }
            this.preparedForSearch = true;
        }

        public boolean containsEntityCommitForTxnId(long logLSN, TxnEntityId txnEntityId) throws IOException {
            if (this.jobEntitCommitOnDiskPartitionsFiles.size() == 0) {
                return this.cachedEntityCommitTxns.contains(txnEntityId);
            }
            ArrayList<File> candidatePartitions = this.getCandidiatePartitions(logLSN);
            for (File partition : candidatePartitions) {
                if (!this.serachPartition(partition, txnEntityId)) continue;
                return true;
            }
            return false;
        }

        public ArrayList<File> getCandidiatePartitions(long logLSN) {
            ArrayList<File> candidiatePartitions = new ArrayList<File>();
            for (File partition : this.jobEntitCommitOnDiskPartitionsFiles) {
                String partitionName = partition.getName();
                if (this.getPartitionMaxLSNFromName(partitionName) <= logLSN) continue;
                candidiatePartitions.add(partition);
            }
            return candidiatePartitions;
        }

        public void clear() {
            this.cachedEntityCommitTxns.clear();
            for (File partition : this.jobEntitCommitOnDiskPartitionsFiles) {
                partition.delete();
            }
            this.jobEntitCommitOnDiskPartitionsFiles.clear();
        }

        private boolean serachPartition(File partition, TxnEntityId txnEntityId) throws IOException {
            if (!partition.getName().equals(this.currentPartitonName)) {
                this.loadPartitionToMemory(partition, this.cachedEntityCommitTxns);
                this.currentPartitonName = partition.getName();
            }
            return this.cachedEntityCommitTxns.contains(txnEntityId);
        }

        private String getPartitionName(long maxLSN) {
            return this.txnId + PARTITION_FILE_NAME_SEPARATOR + maxLSN;
        }

        private long getPartitionMaxLSNFromName(String partitionName) {
            return Long.valueOf(partitionName.substring(partitionName.indexOf(PARTITION_FILE_NAME_SEPARATOR) + 1));
        }

        private void writeCurrentPartitionToDisk() throws IOException {
            if (RecoveryManager.this.needToFreeMemory()) {
                RecoveryManager.this.freeJobsCachedEntities(this.txnId);
            }
            ByteBuffer buffer = ByteBuffer.allocate(this.currentPartitionSize);
            Iterator<TxnEntityId> iterator = this.cachedEntityCommitTxns.iterator();
            while (iterator.hasNext()) {
                TxnEntityId txnEntityId = iterator.next();
                txnEntityId.serialize(buffer);
                iterator.remove();
            }
            File partitionFile = RecoveryManager.this.createJobRecoveryFile(this.txnId, this.getPartitionName(this.partitionMaxLSN));
            try (FileOutputStream fileOutputstream = new FileOutputStream(partitionFile, false);
                 FileChannel fileChannel = fileOutputstream.getChannel();){
                buffer.flip();
                while (buffer.hasRemaining()) {
                    fileChannel.write(buffer);
                }
            }
            this.jobEntitCommitOnDiskPartitionsFiles.add(partitionFile);
        }

        private void loadPartitionToMemory(File partition, Set<TxnEntityId> partitionTxn) throws IOException {
            partitionTxn.clear();
            if (RecoveryManager.this.needToFreeMemory()) {
                RecoveryManager.this.freeJobsCachedEntities(this.txnId);
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)partition.length());
            try (FileInputStream is = new FileInputStream(partition);){
                int readByte;
                while ((readByte = ((InputStream)is).read()) != -1) {
                    buffer.put((byte)readByte);
                }
            }
            buffer.flip();
            while (buffer.remaining() != 0) {
                TxnEntityId temp = TxnEntityId.deserialize((ByteBuffer)buffer);
                partitionTxn.add(temp);
            }
        }
    }
}

