/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IndexCheckpoint;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexCheckpointManager
implements IIndexCheckpointManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int HISTORY_CHECKPOINTS = 1;
    private static final int MAX_CHECKPOINT_WRITE_ATTEMPTS = 5;
    private static final FilenameFilter CHECKPOINT_FILE_FILTER = (file, name) -> name.startsWith(".idx_checkpoint_");
    private static final long BULKLOAD_LSN = 0L;
    private final Path indexPath;

    public IndexCheckpointManager(Path indexPath) {
        this.indexPath = indexPath;
    }

    public synchronized void init(long lsn) throws HyracksDataException {
        List<IndexCheckpoint> checkpoints = this.getCheckpoints();
        if (!checkpoints.isEmpty()) {
            LOGGER.warn(() -> "Checkpoints found on initializing: " + this.indexPath);
            this.delete();
        }
        IndexCheckpoint firstCheckpoint = IndexCheckpoint.first((long)lsn);
        this.persist(firstCheckpoint);
    }

    public synchronized void replicated(String componentTimestamp, long masterLsn) throws HyracksDataException {
        Long localLsn = (Long)this.getLatest().getMasterNodeFlushMap().get(masterLsn);
        if (localLsn == null) {
            throw new IllegalStateException("Component flushed before lsn mapping was received");
        }
        this.flushed(componentTimestamp, localLsn);
    }

    public synchronized void flushed(String componentTimestamp, long lsn) throws HyracksDataException {
        IndexCheckpoint latest = this.getLatest();
        IndexCheckpoint nextCheckpoint = IndexCheckpoint.next((IndexCheckpoint)latest, (long)lsn, (String)componentTimestamp);
        this.persist(nextCheckpoint);
        this.deleteHistory(nextCheckpoint.getId(), 1);
    }

    public synchronized void masterFlush(long masterLsn, long localLsn) throws HyracksDataException {
        IndexCheckpoint latest = this.getLatest();
        latest.getMasterNodeFlushMap().put(masterLsn, localLsn);
        IndexCheckpoint next = IndexCheckpoint.next((IndexCheckpoint)latest, (long)latest.getLowWatermark(), (String)latest.getValidComponentTimestamp());
        this.persist(next);
        this.notifyAll();
    }

    public synchronized long getLowWatermark() {
        return this.getLatest().getLowWatermark();
    }

    public synchronized boolean isFlushed(long masterLsn) {
        if (masterLsn == 0L) {
            return true;
        }
        return this.getLatest().getMasterNodeFlushMap().containsKey(masterLsn);
    }

    public synchronized void delete() {
        this.deleteHistory(Long.MAX_VALUE, 0);
    }

    public Optional<String> getValidComponentTimestamp() {
        String validComponentTimestamp = this.getLatest().getValidComponentTimestamp();
        return validComponentTimestamp != null ? Optional.of(validComponentTimestamp) : Optional.empty();
    }

    public int getCheckpointCount() {
        return this.getCheckpoints().size();
    }

    private IndexCheckpoint getLatest() {
        List<IndexCheckpoint> checkpoints = this.getCheckpoints();
        if (checkpoints.isEmpty()) {
            throw new IllegalStateException("Couldn't find any checkpoints for resource: " + this.indexPath);
        }
        checkpoints.sort(Comparator.comparingLong(IndexCheckpoint::getId).reversed());
        return checkpoints.get(0);
    }

    private List<IndexCheckpoint> getCheckpoints() {
        ArrayList<IndexCheckpoint> checkpoints = new ArrayList<IndexCheckpoint>();
        File[] checkpointFiles = this.indexPath.toFile().listFiles(CHECKPOINT_FILE_FILTER);
        if (checkpointFiles != null) {
            for (File checkpointFile : checkpointFiles) {
                try {
                    checkpoints.add(this.read(checkpointFile.toPath()));
                }
                catch (IOException e) {
                    LOGGER.warn(() -> "Couldn't read index checkpoint file: " + checkpointFile, (Throwable)e);
                }
            }
        }
        return checkpoints;
    }

    private void persist(IndexCheckpoint checkpoint) throws HyracksDataException {
        Path checkpointPath = this.getCheckpointPath(checkpoint);
        for (int i = 1; i <= 5; ++i) {
            try {
                if (checkpointPath.toFile().exists()) {
                    Files.delete(checkpointPath);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(checkpointPath, new OpenOption[0]);){
                    writer.write(checkpoint.asJson());
                }
                this.read(checkpointPath);
                return;
            }
            catch (IOException e) {
                if (i == 5) {
                    throw HyracksDataException.create((Throwable)e);
                }
                LOGGER.warn(() -> "Filed to write checkpoint at: " + this.indexPath, (Throwable)e);
                int nextAttempt = i + 1;
                LOGGER.info(() -> "Checkpoint write attempt " + nextAttempt + "/" + 5);
                continue;
            }
        }
    }

    private IndexCheckpoint read(Path checkpointPath) throws IOException {
        return IndexCheckpoint.fromJson((String)new String(Files.readAllBytes(checkpointPath)));
    }

    private void deleteHistory(long latestId, int historyToKeep) {
        try {
            File[] checkpointFiles = this.indexPath.toFile().listFiles(CHECKPOINT_FILE_FILTER);
            if (checkpointFiles != null) {
                for (File checkpointFile : checkpointFiles) {
                    if (this.getCheckpointIdFromFileName(checkpointFile.toPath()) >= latestId - (long)historyToKeep) continue;
                    Files.delete(checkpointFile.toPath());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn(() -> "Couldn't delete history checkpoints at " + this.indexPath, (Throwable)e);
        }
    }

    private Path getCheckpointPath(IndexCheckpoint checkpoint) {
        return Paths.get(this.indexPath.toString(), ".idx_checkpoint_" + String.valueOf(checkpoint.getId()));
    }

    private long getCheckpointIdFromFileName(Path checkpointPath) {
        return Long.valueOf(checkpointPath.getFileName().toString().substring(".idx_checkpoint_".length()));
    }
}

