/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.external;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.asterix.app.external.ExternalLibraryUtils;
import org.apache.asterix.app.external.IExternalUDFLibrarian;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class ExternalUDFLibrarian
implements IExternalUDFLibrarian {
    private final List<ILibraryManager> libraryManagers;

    public ExternalUDFLibrarian(List<ILibraryManager> libraryManagers) {
        this.libraryManagers = libraryManagers;
    }

    public static void removeLibraryDir() throws IOException {
        File installLibDir = ExternalLibraryUtils.getLibraryInstallDir();
        FileUtils.deleteQuietly((File)installLibDir);
    }

    public static void unzip(String sourceFile, String outputDir) throws IOException {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            try (ZipFile zipFile = new ZipFile(sourceFile);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    File entryDestination = new File(outputDir, entry.getName());
                    if (entry.isDirectory()) continue;
                    entryDestination.getParentFile().mkdirs();
                    InputStream in = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        FileOutputStream out = new FileOutputStream(entryDestination);
                        Throwable throwable2 = null;
                        try {
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable2 != null) {
                                try {
                                    ((OutputStream)out).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            ((OutputStream)out).close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
        }
        Process process = new ProcessBuilder("unzip", "-d", outputDir, sourceFile).start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    @Override
    public void install(String dvName, String libName, String libPath) throws Exception {
        File installLibDir = ExternalLibraryUtils.getLibraryInstallDir();
        if (!installLibDir.exists()) {
            installLibDir.mkdir();
        }
        File destinationDir = new File(installLibDir.getAbsolutePath() + File.separator + dvName + File.separator + libName);
        FileUtils.deleteQuietly((File)destinationDir);
        destinationDir.mkdirs();
        try {
            ExternalUDFLibrarian.unzip(libPath, destinationDir.getAbsolutePath());
        }
        catch (Exception e) {
            throw new Exception("Couldn't unzip the file: " + libPath, e);
        }
        for (ILibraryManager libraryManager : this.libraryManagers) {
            ExternalLibraryUtils.registerClassLoader(libraryManager, dvName, libName);
            ExternalLibraryUtils.configureLibrary(libraryManager, dvName, destinationDir, new HashMap<String, List<String>>(), this.libraryManagers.indexOf(libraryManager) != 0);
        }
    }

    @Override
    public void uninstall(String dvName, String libName) throws RemoteException, AsterixException, ACIDException {
        ExternalLibraryUtils.uninstallLibrary(dvName, libName);
        for (ILibraryManager libraryManager : this.libraryManagers) {
            libraryManager.deregisterLibraryClassLoader(dvName, libName);
        }
    }

    public void cleanup() throws AsterixException, RemoteException, ACIDException {
        for (ILibraryManager libraryManager : this.libraryManagers) {
            List libs = libraryManager.getAllLibraries();
            for (Pair dvAndLib : libs) {
                ExternalLibraryUtils.uninstallLibrary((String)dvAndLib.first, (String)dvAndLib.second);
                libraryManager.deregisterLibraryClassLoader((String)dvAndLib.first, (String)dvAndLib.second);
            }
        }
        File installLibDir = ExternalLibraryUtils.getLibraryInstallDir();
        FileUtils.deleteQuietly((File)installLibDir);
    }
}

