/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.active;

import java.util.concurrent.Callable;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IRetryPolicy;
import org.apache.asterix.active.IRetryPolicyFactory;
import org.apache.asterix.active.NoRetryPolicyFactory;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.MetadataLockUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecoveryTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Level level = Level.INFO;
    private final ActiveEntityEventsListener listener;
    private volatile boolean cancelRecovery = false;
    private final IRetryPolicyFactory retryPolicyFactory;
    private final MetadataProvider metadataProvider;
    private final IClusterStateManager clusterStateManager;
    private Exception failure;

    public RecoveryTask(ICcApplicationContext appCtx, ActiveEntityEventsListener listener, IRetryPolicyFactory retryPolicyFactory) {
        this.listener = listener;
        this.retryPolicyFactory = retryPolicyFactory;
        this.metadataProvider = new MetadataProvider(appCtx, null);
        this.clusterStateManager = appCtx.getClusterStateManager();
    }

    public Callable<Void> recover() {
        if (this.retryPolicyFactory == NoRetryPolicyFactory.INSTANCE) {
            return () -> null;
        }
        IRetryPolicy policy = this.retryPolicyFactory.create((IActiveEntityEventsListener)this.listener);
        return () -> {
            Thread.currentThread().setName("RecoveryTask (" + this.listener.getEntityId() + ")");
            this.doRecover(policy);
            return null;
        };
    }

    public void cancel() {
        this.cancelRecovery = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeOrRecover(MetadataProvider metadataProvider) throws HyracksDataException {
        try {
            ActiveEntityEventsListener activeEntityEventsListener = this.listener;
            synchronized (activeEntityEventsListener) {
                this.listener.doResume(metadataProvider);
                this.listener.setState(ActivityState.RUNNING);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Attempt to resume " + this.listener.getEntityId() + " Failed", (Throwable)e);
            ActiveEntityEventsListener activeEntityEventsListener = this.listener;
            synchronized (activeEntityEventsListener) {
                if (this.listener.getState() == ActivityState.RESUMING) {
                    this.listener.setState(ActivityState.TEMPORARILY_FAILED);
                }
            }
            if (this.retryPolicyFactory == NoRetryPolicyFactory.INSTANCE) {
                activeEntityEventsListener = this.listener;
                synchronized (activeEntityEventsListener) {
                    if (!this.cancelRecovery) {
                        this.listener.setState(ActivityState.PERMANENTLY_FAILED);
                    }
                }
            } else {
                LOGGER.log(Level.WARN, "Submitting recovery task for " + this.listener.getEntityId());
                metadataProvider.getApplicationContext().getServiceContext().getControllerService().getExecutor().submit(() -> this.doRecover(this.retryPolicyFactory.create((IActiveEntityEventsListener)this.listener)));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Void doRecover(IRetryPolicy policy) throws AlgebricksException, HyracksDataException, InterruptedException {
        Object object;
        ActiveEntityEventsListener lockManager;
        LOGGER.log(level, "Actual Recovery task has started");
        if (this.listener.getState() != ActivityState.TEMPORARILY_FAILED) {
            LOGGER.log(level, "but its state is not temp failure and so we're just returning");
            return null;
        }
        LOGGER.log(level, "calling the policy");
        while (policy.retry()) {
            ActiveEntityEventsListener activeEntityEventsListener = this.listener;
            synchronized (activeEntityEventsListener) {
                if (this.cancelRecovery) {
                    return null;
                }
                while (this.clusterStateManager.getState() != IClusterManagementWork.ClusterState.ACTIVE) {
                    if (this.cancelRecovery) {
                        return null;
                    }
                    this.listener.wait();
                }
            }
            lockManager = this.metadataProvider.getApplicationContext().getMetadataLockManager();
            lockManager.acquireActiveEntityWriteLock(this.metadataProvider.getLocks(), this.listener.getEntityId().getDataverse() + '.' + this.listener.getEntityId().getEntityName());
            for (Dataset dataset : this.listener.getDatasets()) {
                lockManager.acquireDataverseReadLock(this.metadataProvider.getLocks(), dataset.getDataverseName());
                lockManager.acquireDatasetExclusiveModificationLock(this.metadataProvider.getLocks(), DatasetUtil.getFullyQualifiedName((Dataset)dataset));
            }
            object = this.listener;
            synchronized (object) {
                try {
                    Dataset dataset;
                    if (this.cancelRecovery) {
                        dataset = null;
                        return dataset;
                    }
                    this.listener.setState(ActivityState.RECOVERING);
                    this.listener.doStart(this.metadataProvider);
                    dataset = null;
                    return dataset;
                }
                catch (Exception e) {
                    LOGGER.log(level, "Attempt to revive " + this.listener.getEntityId() + " failed", (Throwable)e);
                    this.listener.setState(ActivityState.TEMPORARILY_FAILED);
                    this.failure = e;
                }
                finally {
                    this.metadataProvider.getLocks().reset();
                }
                this.listener.notifyAll();
            }
        }
        lockManager = this.listener;
        synchronized (lockManager) {
            this.listener.notifyAll();
            if (this.listener.getState() != ActivityState.TEMPORARILY_FAILED) {
                return null;
            }
        }
        lockManager = this.metadataProvider.getApplicationContext().getMetadataLockManager();
        try {
            lockManager.acquireActiveEntityWriteLock(this.metadataProvider.getLocks(), this.listener.getEntityId().getDataverse() + '.' + this.listener.getEntityId().getEntityName());
            for (Dataset dataset : this.listener.getDatasets()) {
                MetadataLockUtil.modifyDatasetBegin((IMetadataLockManager)lockManager, (LockList)this.metadataProvider.getLocks(), (String)dataset.getDatasetName(), (String)DatasetUtil.getFullyQualifiedName((Dataset)dataset));
            }
            object = this.listener;
            synchronized (object) {
                if (this.cancelRecovery) {
                    Void void_ = null;
                    return void_;
                }
                if (this.listener.getState() == ActivityState.TEMPORARILY_FAILED) {
                    this.listener.setState(ActivityState.PERMANENTLY_FAILED);
                }
                this.listener.notifyAll();
                return null;
            }
        }
        finally {
            this.metadataProvider.getLocks().reset();
        }
    }

    public Exception getFailure() {
        return this.failure;
    }
}

