/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.http.server.ClusterApiServlet;
import org.apache.asterix.api.http.server.NodeControllerDetailsHelper;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeControllerDetailsApiServlet
extends ClusterApiServlet {
    private static final Logger LOGGER = LogManager.getLogger();

    public NodeControllerDetailsApiServlet(ICcApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String ... paths) {
        super(appCtx, ctx, paths);
    }

    @Override
    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        PrintWriter responseWriter = response.writer();
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        try {
            ObjectNode json;
            response.setStatus(HttpResponseStatus.OK);
            if ("".equals(this.localPath(request))) {
                json = OBJECT_MAPPER.createObjectNode();
                json.set("ncs", this.getClusterStateJSON(request, "../").get("ncs"));
            } else {
                json = this.processNode(request, hcc);
            }
            HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
            responseWriter.write(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
        }
        catch (IllegalStateException e) {
            response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
        }
        catch (IllegalArgumentException e) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception thrown for " + request, (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            responseWriter.write(e.toString());
        }
        responseWriter.flush();
    }

    private ObjectNode processNode(IServletRequest request, IHyracksClientConnection hcc) throws Exception {
        String localPath = this.localPath(request);
        if (localPath.endsWith("/")) {
            throw new IllegalArgumentException();
        }
        String[] parts = localPath.substring(1).split("/");
        String node = parts[0];
        if (parts.length == 1) {
            ArrayNode ncs = (ArrayNode)this.getClusterStateJSON(request, "../../").get("ncs");
            for (int i = 0; i < ncs.size(); ++i) {
                if (!node.equals(ncs.get(i).get("node_id").asText())) continue;
                return (ObjectNode)ncs.get(i);
            }
            if ("cc".equals(node)) {
                return OBJECT_MAPPER.createObjectNode();
            }
            throw new IllegalArgumentException();
        }
        if (parts.length == 2) {
            ObjectNode json;
            switch (parts[1]) {
                case "config": {
                    json = this.processNodeConfig(hcc, node);
                    break;
                }
                case "stats": {
                    json = this.processNodeStats(hcc, node);
                    break;
                }
                case "threaddump": {
                    return this.processNodeThreadDump(hcc, node);
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            NodeControllerDetailsHelper.fixupKeys(json);
            return json;
        }
        throw new IllegalArgumentException();
    }

    protected ObjectNode processNodeStats(IHyracksClientConnection hcc, String node) throws Exception {
        String details = this.checkNullDetail(node, hcc.getNodeDetailsJSON(node, true, false));
        return NodeControllerDetailsHelper.processNodeDetailsJSON((ObjectNode)OBJECT_MAPPER.readTree(details), OBJECT_MAPPER);
    }

    private ObjectNode processNodeConfig(IHyracksClientConnection hcc, String node) throws Exception {
        String config = this.checkNullDetail(node, hcc.getNodeDetailsJSON(node, false, true));
        return (ObjectNode)OBJECT_MAPPER.readTree(config);
    }

    private ObjectNode processNodeThreadDump(IHyracksClientConnection hcc, String node) throws Exception {
        if ("cc".equals(node)) {
            return OBJECT_MAPPER.createObjectNode();
        }
        String dump = this.checkNullDetail(node, hcc.getThreadDump(node));
        return (ObjectNode)OBJECT_MAPPER.readTree(dump);
    }

    protected String checkNullDetail(String node, String value) {
        if (value != null) {
            return value;
        }
        if (node == null) {
            throw new IllegalStateException("unable to obtain detail from cc");
        }
        IClusterStateManager csm = this.appCtx.getClusterStateManager();
        ClusterPartition[] cp = csm.getNodePartitions(node);
        throw cp != null ? new IllegalStateException("unable to obtain detail from node " + node) : new IllegalArgumentException("unknown node " + node);
    }
}

