/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.QueryServiceServlet;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.message.CancelQueryRequest;
import org.apache.asterix.app.message.ExecuteStatementRequestMessage;
import org.apache.asterix.app.message.ExecuteStatementResponseMessage;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.common.api.Duration;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.exceptions.ExceptionUtils;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.ResultProperties;
import org.apache.asterix.translator.SessionOutput;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.http.api.IChannelClosedHandler;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.InterruptOnCloseHandler;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.logging.log4j.Level;

public class NCQueryServiceServlet
extends QueryServiceServlet {
    public NCQueryServiceServlet(ConcurrentMap<String, Object> ctx, String[] paths, IApplicationContext appCtx, ILangExtension.Language queryLanguage, Function<IServletRequest, Map<String, String>> optionalParamProvider) {
        super(ctx, paths, appCtx, queryLanguage, null, null, null, optionalParamProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeStatement(String statementsText, SessionOutput sessionOutput, ResultProperties resultProperties, IStatementExecutor.Stats stats, QueryServiceServlet.RequestParameters param, QueryServiceServlet.RequestExecutionState execution, Map<String, String> optionalParameters) throws Exception {
        ExecuteStatementResponseMessage responseMsg;
        INCServiceContext ncCtx = (INCServiceContext)this.serviceCtx;
        INCMessageBroker ncMb = (INCMessageBroker)ncCtx.getMessageBroker();
        IStatementExecutor.ResultDelivery delivery = resultProperties.getDelivery();
        MessageFuture responseFuture = ncMb.registerMessageFuture();
        String handleUrl = this.getHandleUrl(param.host, param.path, delivery);
        try {
            if (param.clientContextID == null) {
                param.clientContextID = UUID.randomUUID().toString();
            }
            long timeout = ExecuteStatementRequestMessage.DEFAULT_NC_TIMEOUT_MILLIS;
            if (param.timeout != null && !param.timeout.trim().isEmpty()) {
                timeout = TimeUnit.NANOSECONDS.toMillis(Duration.parseDurationStringToNanos((String)param.timeout));
            }
            ExecuteStatementRequestMessage requestMsg = new ExecuteStatementRequestMessage(ncCtx.getNodeId(), responseFuture.getFutureId(), this.queryLanguage, statementsText, sessionOutput.config(), resultProperties.getNcToCcResultProperties(), param.clientContextID, handleUrl, optionalParameters);
            execution.start();
            ncMb.sendMessageToPrimaryCC((ICcAddressedMessage)requestMsg);
            try {
                responseMsg = (ExecuteStatementResponseMessage)responseFuture.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.cancelQuery(ncMb, ncCtx.getNodeId(), param.clientContextID, e, false);
                throw e;
            }
            catch (TimeoutException exception) {
                RuntimeDataException hde = new RuntimeDataException(30, new Serializable[0]);
                hde.addSuppressed((Throwable)exception);
                this.cancelQuery(ncMb, ncCtx.getNodeId(), param.clientContextID, (Exception)hde, true);
                throw hde;
            }
            execution.end();
        }
        finally {
            ncMb.deregisterMessageFuture(responseFuture.getFutureId());
        }
        Throwable err = responseMsg.getError();
        if (err != null) {
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof Exception) {
                throw (Exception)err;
            }
            throw new Exception(err.toString(), err);
        }
        sessionOutput.release();
        IStatementExecutor.ResultMetadata resultMetadata = responseMsg.getMetadata();
        if (delivery == IStatementExecutor.ResultDelivery.IMMEDIATE && !resultMetadata.getResultSets().isEmpty()) {
            stats.setProcessedObjects(responseMsg.getStats().getProcessedObjects());
            for (Triple rsmd : resultMetadata.getResultSets()) {
                ResultReader resultReader = new ResultReader(this.getHyracksDataset(), (JobId)rsmd.getLeft(), (ResultSetId)rsmd.getMiddle());
                ResultUtil.printResults(this.appCtx, resultReader, sessionOutput, stats, (ARecordType)rsmd.getRight());
            }
        } else {
            sessionOutput.out().append(responseMsg.getResult());
        }
        this.printExecutionPlans(sessionOutput, responseMsg.getExecutionPlans());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQuery(INCMessageBroker messageBroker, String nodeId, String clientContextID, Exception exception, boolean wait) {
        MessageFuture cancelQueryFuture = messageBroker.registerMessageFuture();
        try {
            CancelQueryRequest cancelQueryMessage = new CancelQueryRequest(nodeId, cancelQueryFuture.getFutureId(), clientContextID);
            messageBroker.sendMessageToPrimaryCC((ICcAddressedMessage)cancelQueryMessage);
            if (wait) {
                cancelQueryFuture.get(ExecuteStatementRequestMessage.DEFAULT_QUERY_CANCELLATION_WAIT_MILLIS, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            exception.addSuppressed(e);
        }
        finally {
            messageBroker.deregisterMessageFuture(cancelQueryFuture.getFutureId());
        }
    }

    @Override
    protected void handleExecuteStatementException(Throwable t, QueryServiceServlet.RequestExecutionState state, QueryServiceServlet.RequestParameters param) {
        if (t instanceof TimeoutException || ExceptionUtils.matchingCause((Throwable)t, candidate -> candidate instanceof IPCException)) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.WARN, t.toString(), t);
            state.setStatus(AbstractQueryApiServlet.ResultStatus.FAILED, HttpResponseStatus.SERVICE_UNAVAILABLE);
        } else {
            super.handleExecuteStatementException(t, state, param);
        }
    }

    public IChannelClosedHandler getChannelClosedHandler(HttpServer server) {
        return InterruptOnCloseHandler.INSTANCE;
    }
}

