/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslator;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslatorFactory;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.INodeJobTracker;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.OptimizationConfUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.Job;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.compiler.provider.IRuleSetFactory;
import org.apache.asterix.dataflow.data.common.ConflictingTypeResolver;
import org.apache.asterix.dataflow.data.common.ExpressionTypeComputer;
import org.apache.asterix.dataflow.data.common.MergeAggregationExpressionFactory;
import org.apache.asterix.dataflow.data.common.MissableTypeComputer;
import org.apache.asterix.dataflow.data.common.PartialAggregationTypeComputer;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.jobgen.QueryLogicalExpressionJobGen;
import org.apache.asterix.lang.common.base.IAstPrintVisitorFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.asterix.utils.ResourceUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.compiler.api.HeuristicCompilerFactoryBuilder;
import org.apache.hyracks.algebricks.compiler.api.ICompiler;
import org.apache.hyracks.algebricks.compiler.api.ICompilerFactory;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.ExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IConflictingTypeResolver;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionEvalSizeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.ILogicalExpressionJobGen;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IPartialAggregationTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AbstractLogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitorJson;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.rewriter.base.AlgebricksOptimizationContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IOptimizationContextFactory;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.data.IPrinterFactoryProvider;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.resource.IClusterCapacity;
import org.apache.hyracks.control.common.config.OptionTypes;

public class APIFramework {
    private static final int MIN_FRAME_LIMIT_FOR_SORT = 3;
    private static final int MIN_FRAME_LIMIT_FOR_GROUP_BY = 4;
    private static final int MIN_FRAME_LIMIT_FOR_JOIN = 5;
    private static final int MIN_FRAME_LIMIT_FOR_TEXTSEARCH = 5;
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private static final Set<String> CONFIGURABLE_PARAMETER_NAMES = ImmutableSet.of((Object)CompilerProperties.COMPILER_JOINMEMORY_KEY, (Object)CompilerProperties.COMPILER_GROUPMEMORY_KEY, (Object)CompilerProperties.COMPILER_SORTMEMORY_KEY, (Object)CompilerProperties.COMPILER_TEXTSEARCHMEMORY_KEY, (Object)CompilerProperties.COMPILER_PARALLELISM_KEY, (Object)"import-private-functions", (Object[])new String[]{"simfunction", "simthreshold", "wait-for-completion-feed", "feed-policy-name", "collect-locations", "inline_with", "hash_merge", "output-record-type", "noindexonly"});
    private final IRewriterFactory rewriterFactory;
    private final IAstPrintVisitorFactory astPrintVisitorFactory;
    private final ILangExpressionToPlanTranslatorFactory translatorFactory;
    private final IRuleSetFactory ruleSetFactory;
    private final ExecutionPlans executionPlans;

    public APIFramework(ILangCompilationProvider compilationProvider) {
        this.rewriterFactory = compilationProvider.getRewriterFactory();
        this.astPrintVisitorFactory = compilationProvider.getAstPrintVisitorFactory();
        this.translatorFactory = compilationProvider.getExpressionToPlanTranslatorFactory();
        this.ruleSetFactory = compilationProvider.getRuleSetFactory();
        this.executionPlans = new ExecutionPlans();
    }

    public Pair<IReturningStatement, Integer> reWriteQuery(List<FunctionDecl> declaredFunctions, MetadataProvider metadataProvider, IReturningStatement q, SessionOutput output, boolean inlineUdfs) throws CompilationException {
        if (q == null) {
            return null;
        }
        SessionConfig conf = output.config();
        if (!conf.is("format-only-physical-ops") && conf.is("oob-expr-tree")) {
            this.generateExpressionTree(q);
        }
        IQueryRewriter rw = this.rewriterFactory.createQueryRewriter();
        rw.rewrite(declaredFunctions, q, metadataProvider, new LangRewritingContext(q.getVarCounter()), inlineUdfs);
        return new Pair((Object)q, (Object)q.getVarCounter());
    }

    public JobSpecification compileQuery(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, Query query, int varCounter, String outputDatasetName, SessionOutput output, CompiledStatements.ICompiledDmlStatement statement) throws AlgebricksException, ACIDException {
        ILogicalPlan plan;
        boolean isQuery = query != null;
        boolean isLoad = statement != null && statement.getKind() == Statement.Kind.LOAD;
        SessionConfig conf = output.config();
        if (isQuery && !conf.is("format-only-physical-ops") && conf.is("oob-rewritten-expr-tree")) {
            this.generateRewrittenExpressionTree((IReturningStatement)query);
        }
        TxnId txnId = metadataProvider.getTxnIdFactory().create();
        metadataProvider.setTxnId(txnId);
        ILangExpressionToPlanTranslator t = this.translatorFactory.createExpressionToPlanTranslator(metadataProvider, varCounter);
        ILogicalPlan iLogicalPlan = plan = isLoad ? t.translateLoad(statement) : t.translate(query, outputDatasetName, statement);
        if ((isQuery || isLoad) && !conf.is("format-only-physical-ops") && conf.is("oob-logical-plan")) {
            this.generateLogicalPlan(plan, output.config().getPlanFormat());
        }
        CompilerProperties compilerProperties = metadataProvider.getApplicationContext().getCompilerProperties();
        Map<String, String> querySpecificConfig = APIFramework.validateConfig(metadataProvider.getConfig());
        PhysicalOptimizationConfig physOptConf = this.getPhysicalOptimizationConfig(compilerProperties, querySpecificConfig);
        HeuristicCompilerFactoryBuilder builder = new HeuristicCompilerFactoryBuilder((IOptimizationContextFactory)OptimizationContextFactory.INSTANCE);
        builder.setPhysicalOptimizationConfig(physOptConf);
        builder.setLogicalRewrites(this.ruleSetFactory.getLogicalRewrites(metadataProvider.getApplicationContext()));
        builder.setPhysicalRewrites(this.ruleSetFactory.getPhysicalRewrites(metadataProvider.getApplicationContext()));
        IDataFormat format = metadataProvider.getDataFormat();
        ICompilerFactory compilerFactory = builder.create();
        builder.setExpressionEvalSizeComputer(format.getExpressionEvalSizeComputer());
        builder.setIMergeAggregationExpressionFactory((IMergeAggregationExpressionFactory)new MergeAggregationExpressionFactory());
        builder.setPartialAggregationTypeComputer((IPartialAggregationTypeComputer)new PartialAggregationTypeComputer());
        builder.setExpressionTypeComputer((IExpressionTypeComputer)ExpressionTypeComputer.INSTANCE);
        builder.setMissableTypeComputer((IMissableTypeComputer)MissableTypeComputer.INSTANCE);
        builder.setConflictingTypeResolver((IConflictingTypeResolver)ConflictingTypeResolver.INSTANCE);
        int parallelism = APIFramework.getParallelism(querySpecificConfig.get(CompilerProperties.COMPILER_PARALLELISM_KEY), compilerProperties.getParallelism());
        AlgebricksAbsolutePartitionConstraint computationLocations = APIFramework.chooseLocations(clusterInfoCollector, parallelism, metadataProvider.getClusterLocations());
        builder.setClusterLocations(computationLocations);
        ICompiler compiler = compilerFactory.createCompiler(plan, (IMetadataProvider)metadataProvider, t.getVarCounter());
        if (conf.isOptimize()) {
            compiler.optimize();
            if (conf.is("oob-optimized-logical-plan")) {
                if (conf.is("format-only-physical-ops")) {
                    AlgebricksAppendable buffer = new AlgebricksAppendable((Appendable)output.out());
                    PlanPrettyPrinter.printPhysicalOps((ILogicalPlan)plan, (AlgebricksAppendable)buffer, (int)0);
                } else if (isQuery || isLoad) {
                    this.generateOptimizedLogicalPlan(plan, output.config().getPlanFormat());
                }
            }
        }
        if (isQuery && query.isExplain()) {
            try {
                LogicalOperatorPrettyPrintVisitor pvisitor = new LogicalOperatorPrettyPrintVisitor();
                PlanPrettyPrinter.printPlan((ILogicalPlan)plan, (AbstractLogicalOperatorPrettyPrintVisitor)pvisitor, (int)0);
                ResultUtil.printResults((IApplicationContext)metadataProvider.getApplicationContext(), pvisitor.get().toString(), output, new IStatementExecutor.Stats(), null);
                return null;
            }
            catch (IOException e) {
                throw new AlgebricksException((Throwable)e);
            }
        }
        if (!conf.isGenerateJobSpec()) {
            return null;
        }
        builder.setBinaryBooleanInspectorFactory(format.getBinaryBooleanInspectorFactory());
        builder.setBinaryIntegerInspectorFactory(format.getBinaryIntegerInspectorFactory());
        builder.setComparatorFactoryProvider(format.getBinaryComparatorFactoryProvider());
        builder.setExpressionRuntimeProvider((IExpressionRuntimeProvider)new ExpressionRuntimeProvider((ILogicalExpressionJobGen)new QueryLogicalExpressionJobGen(metadataProvider.getFunctionManager())));
        builder.setHashFunctionFactoryProvider(format.getBinaryHashFunctionFactoryProvider());
        builder.setHashFunctionFamilyProvider(format.getBinaryHashFunctionFamilyProvider());
        builder.setMissingWriterFactory(format.getMissingWriterFactory());
        builder.setPredicateEvaluatorFactoryProvider(format.getPredicateEvaluatorFactoryProvider());
        builder.setPrinterProvider(this.getPrinterFactoryProvider(format, conf.fmt()));
        builder.setSerializerDeserializerProvider(format.getSerdeProvider());
        builder.setTypeTraitProvider(format.getTypeTraitProvider());
        builder.setNormalizedKeyComputerFactoryProvider(format.getNormalizedKeyComputerFactoryProvider());
        JobEventListenerFactory jobEventListenerFactory = new JobEventListenerFactory(txnId, metadataProvider.isWriteTransaction());
        JobSpecification spec = compiler.createJob((Object)metadataProvider.getApplicationContext(), (IJobletEventListenerFactory)jobEventListenerFactory);
        if (isQuery) {
            INodeJobTracker nodeJobTracker = metadataProvider.getApplicationContext().getNodeJobTracker();
            AlgebricksAbsolutePartitionConstraint jobLocations = APIFramework.getJobLocations(spec, nodeJobTracker, computationLocations);
            IClusterCapacity jobRequiredCapacity = ResourceUtils.getRequiredCapacity(plan, jobLocations, physOptConf);
            spec.setRequiredClusterCapacity(jobRequiredCapacity);
        }
        if (isQuery && conf.is("oob-hyracks-job")) {
            this.generateJob(spec);
        }
        return spec;
    }

    protected PhysicalOptimizationConfig getPhysicalOptimizationConfig(CompilerProperties compilerProperties, Map<String, String> querySpecificConfig) throws AlgebricksException {
        int frameSize = compilerProperties.getFrameSize();
        int sortFrameLimit = APIFramework.getFrameLimit(CompilerProperties.COMPILER_SORTMEMORY_KEY, querySpecificConfig.get(CompilerProperties.COMPILER_SORTMEMORY_KEY), compilerProperties.getSortMemorySize(), frameSize, 3);
        int groupFrameLimit = APIFramework.getFrameLimit(CompilerProperties.COMPILER_GROUPMEMORY_KEY, querySpecificConfig.get(CompilerProperties.COMPILER_GROUPMEMORY_KEY), compilerProperties.getGroupMemorySize(), frameSize, 4);
        int joinFrameLimit = APIFramework.getFrameLimit(CompilerProperties.COMPILER_JOINMEMORY_KEY, querySpecificConfig.get(CompilerProperties.COMPILER_JOINMEMORY_KEY), compilerProperties.getJoinMemorySize(), frameSize, 5);
        int textSearchFrameLimit = APIFramework.getFrameLimit(CompilerProperties.COMPILER_TEXTSEARCHMEMORY_KEY, querySpecificConfig.get(CompilerProperties.COMPILER_TEXTSEARCHMEMORY_KEY), compilerProperties.getTextSearchMemorySize(), frameSize, 5);
        PhysicalOptimizationConfig physOptConf = OptimizationConfUtil.getPhysicalOptimizationConfig();
        physOptConf.setFrameSize(frameSize);
        physOptConf.setMaxFramesExternalSort(sortFrameLimit);
        physOptConf.setMaxFramesExternalGroupBy(groupFrameLimit);
        physOptConf.setMaxFramesForJoin(joinFrameLimit);
        physOptConf.setMaxFramesForTextSearch(textSearchFrameLimit);
        return physOptConf;
    }

    protected IPrinterFactoryProvider getPrinterFactoryProvider(IDataFormat format, SessionConfig.OutputFormat outputFormat) throws AlgebricksException {
        switch (outputFormat) {
            case LOSSLESS_JSON: {
                return format.getLosslessJSONPrinterFactoryProvider();
            }
            case CSV: {
                return format.getCSVPrinterFactoryProvider();
            }
            case ADM: {
                return format.getADMPrinterFactoryProvider();
            }
            case CLEAN_JSON: {
                return format.getCleanJSONPrinterFactoryProvider();
            }
        }
        throw new AlgebricksException("Unexpected OutputFormat: " + outputFormat);
    }

    private AbstractLogicalOperatorPrettyPrintVisitor getPrettyPrintVisitor(SessionConfig.PlanFormat planFormat, PrintWriter out) {
        return planFormat.equals((Object)SessionConfig.PlanFormat.JSON) ? new LogicalOperatorPrettyPrintVisitorJson((Appendable)out) : new LogicalOperatorPrettyPrintVisitor((Appendable)out);
    }

    public void executeJobArray(IHyracksClientConnection hcc, JobSpecification[] specs, PrintWriter out) throws Exception {
        for (JobSpecification spec : specs) {
            spec.setMaxReattempts(0);
            JobId jobId = hcc.startJob(spec);
            long startTime = System.currentTimeMillis();
            hcc.waitForCompletion(jobId);
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            out.println("<pre>Duration: " + duration + " sec</pre>");
        }
    }

    public void executeJobArray(IHyracksClientConnection hcc, Job[] jobs, PrintWriter out) throws Exception {
        for (Job job : jobs) {
            job.getJobSpec().setMaxReattempts(0);
            long startTime = System.currentTimeMillis();
            try {
                JobId jobId = hcc.startJob(job.getJobSpec());
                if (job.getSubmissionMode() == Job.SubmissionMode.ASYNCHRONOUS) continue;
                hcc.waitForCompletion(jobId);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            out.println("<pre>Duration: " + duration + " sec</pre>");
        }
    }

    public ExecutionPlans getExecutionPlans() {
        return this.executionPlans;
    }

    private static AlgebricksAbsolutePartitionConstraint chooseLocations(IClusterInfoCollector clusterInfoCollector, int parallelismHint, AlgebricksAbsolutePartitionConstraint storageLocations) throws AlgebricksException {
        try {
            Map ncMap = clusterInfoCollector.getNodeControllerInfos();
            int totalNumCores = APIFramework.getTotalNumCores(ncMap);
            if (parallelismHint == 0 && storageLocations.getLocations().length <= totalNumCores) {
                return storageLocations;
            }
            return APIFramework.getComputationLocations(ncMap, parallelismHint);
        }
        catch (HyracksException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private static AlgebricksAbsolutePartitionConstraint getComputationLocations(Map<String, NodeControllerInfo> ncMap, int parallelismHint) {
        int parallelism = parallelismHint <= 0 ? -2 * ncMap.size() : parallelismHint;
        int numNodes = ncMap.size();
        int numNodesWithOneMorePartition = parallelism % numNodes;
        int perNodeParallelismMin = parallelism / numNodes;
        int perNodeParallelismMax = parallelism / numNodes + 1;
        ArrayList allNodes = new ArrayList();
        HashSet selectedNodesWithOneMorePartition = new HashSet();
        ncMap.forEach((key, value) -> allNodes.add(key));
        Random random = new Random();
        for (int index = numNodesWithOneMorePartition; index >= 1; --index) {
            int pick = random.nextInt(index);
            selectedNodesWithOneMorePartition.add(allNodes.get(pick));
            Collections.swap(allNodes, pick, index - 1);
        }
        ArrayList locations = new ArrayList();
        ncMap.forEach((nodeId, value) -> {
            int availableCores = value.getNumAvailableCores();
            int nodeParallelism = selectedNodesWithOneMorePartition.contains(nodeId) ? perNodeParallelismMax : perNodeParallelismMin;
            int coresToUse = nodeParallelism >= 0 && nodeParallelism < availableCores ? nodeParallelism : availableCores;
            for (int count = 0; count < coresToUse; ++count) {
                locations.add(nodeId);
            }
        });
        return new AlgebricksAbsolutePartitionConstraint(locations.toArray(new String[0]));
    }

    private static int getTotalNumCores(Map<String, NodeControllerInfo> ncMap) {
        return ncMap.values().stream().mapToInt(NodeControllerInfo::getNumAvailableCores).sum();
    }

    private static int getFrameLimit(String parameterName, String parameter, long memBudgetInConfiguration, int frameSize, int minFrameLimit) throws AlgebricksException {
        IOptionType longBytePropertyInterpreter = OptionTypes.LONG_BYTE_UNIT;
        long memBudget = parameter == null ? memBudgetInConfiguration : (Long)longBytePropertyInterpreter.parse(parameter);
        int frameLimit = (int)(memBudget / (long)frameSize);
        if (frameLimit < minFrameLimit) {
            throw AsterixException.create((int)1037, (Serializable[])new Serializable[]{parameterName, Integer.valueOf(frameSize * minFrameLimit)});
        }
        return Math.max(frameLimit, minFrameLimit);
    }

    private static int getParallelism(String parameter, int parallelismInConfiguration) {
        IOptionType integerIPropertyInterpreter = OptionTypes.INTEGER;
        return parameter == null ? parallelismInConfiguration : (Integer)integerIPropertyInterpreter.parse(parameter);
    }

    private static Map<String, String> validateConfig(Map<String, String> config) throws AlgebricksException {
        for (String parameterName : config.keySet()) {
            if (CONFIGURABLE_PARAMETER_NAMES.contains(parameterName)) continue;
            throw AsterixException.create((int)1028, (Serializable[])new Serializable[]{parameterName});
        }
        return config;
    }

    private void generateExpressionTree(IReturningStatement statement) throws CompilationException {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            statement.accept((ILangVisitor)this.astPrintVisitorFactory.createLangVisitor(writer), (Object)0);
            this.executionPlans.setExpressionTree(stringWriter.toString());
        }
    }

    private void generateRewrittenExpressionTree(IReturningStatement statement) throws CompilationException {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            statement.accept((ILangVisitor)this.astPrintVisitorFactory.createLangVisitor(writer), (Object)0);
            this.executionPlans.setRewrittenExpressionTree(stringWriter.toString());
        }
    }

    private void generateLogicalPlan(ILogicalPlan plan, SessionConfig.PlanFormat format) throws AlgebricksException {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            PlanPrettyPrinter.printPlan((ILogicalPlan)plan, (AbstractLogicalOperatorPrettyPrintVisitor)this.getPrettyPrintVisitor(format, writer), (int)0);
            this.executionPlans.setLogicalPlan(stringWriter.toString());
        }
    }

    private void generateOptimizedLogicalPlan(ILogicalPlan plan, SessionConfig.PlanFormat format) throws AlgebricksException {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            PlanPrettyPrinter.printPlan((ILogicalPlan)plan, (AbstractLogicalOperatorPrettyPrintVisitor)this.getPrettyPrintVisitor(format, writer), (int)0);
            this.executionPlans.setOptimizedLogicalPlan(stringWriter.toString());
        }
    }

    private void generateJob(JobSpecification spec) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            writer.println(OBJECT_WRITER.writeValueAsString((Object)spec.toJSON()));
            this.executionPlans.setJob(stringWriter.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static AlgebricksAbsolutePartitionConstraint getJobLocations(JobSpecification spec, INodeJobTracker jobTracker, AlgebricksAbsolutePartitionConstraint clusterLocations) {
        Set jobParticipatingNodes = jobTracker.getJobParticipatingNodes(spec);
        return new AlgebricksAbsolutePartitionConstraint((String[])Arrays.stream(clusterLocations.getLocations()).filter(jobParticipatingNodes::contains).toArray(String[]::new));
    }

    private static class OptimizationContextFactory
    implements IOptimizationContextFactory {
        public static final OptimizationContextFactory INSTANCE = new OptimizationContextFactory();

        private OptimizationContextFactory() {
        }

        public IOptimizationContext createOptimizationContext(int varCounter, IExpressionEvalSizeComputer expressionEvalSizeComputer, IMergeAggregationExpressionFactory mergeAggregationExpressionFactory, IExpressionTypeComputer expressionTypeComputer, IMissableTypeComputer missableTypeComputer, IConflictingTypeResolver conflictingTypeResolver, PhysicalOptimizationConfig physicalOptimizationConfig, AlgebricksPartitionConstraint clusterLocations) {
            return new AlgebricksOptimizationContext(varCounter, expressionEvalSizeComputer, mergeAggregationExpressionFactory, expressionTypeComputer, missableTypeComputer, conflictingTypeResolver, physicalOptimizationConfig, clusterLocations);
        }
    }
}

