/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.DFSUtil;

public class SnapshotDiffReport {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private final String snapshotRoot;
    private final String fromSnapshot;
    private final String toSnapshot;
    private final List<DiffReportEntry> diffList;

    public SnapshotDiffReport(String snapshotRoot, String fromSnapshot, String toSnapshot, List<DiffReportEntry> entryList) {
        this.snapshotRoot = snapshotRoot;
        this.fromSnapshot = fromSnapshot;
        this.toSnapshot = toSnapshot;
        this.diffList = entryList != null ? entryList : Collections.emptyList();
    }

    public String getSnapshotRoot() {
        return this.snapshotRoot;
    }

    public String getFromSnapshot() {
        return this.fromSnapshot;
    }

    public String getLaterSnapshotName() {
        return this.toSnapshot;
    }

    public List<DiffReportEntry> getDiffList() {
        return this.diffList;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        String from = this.fromSnapshot == null || this.fromSnapshot.isEmpty() ? "current directory" : "snapshot " + this.fromSnapshot;
        String to = this.toSnapshot == null || this.toSnapshot.isEmpty() ? "current directory" : "snapshot " + this.toSnapshot;
        str.append("Difference between " + from + " and " + to + " under directory " + this.snapshotRoot + ":" + LINE_SEPARATOR);
        for (DiffReportEntry entry : this.diffList) {
            str.append(entry.toString() + LINE_SEPARATOR);
        }
        return str.toString();
    }

    public static class DiffReportEntry {
        private final DiffType type;
        private final byte[] relativePath;

        public DiffReportEntry(DiffType type, byte[] path) {
            this.type = type;
            this.relativePath = path;
        }

        public DiffReportEntry(DiffType type, byte[][] pathComponents) {
            this.type = type;
            this.relativePath = DFSUtil.byteArray2bytes(pathComponents);
        }

        public String toString() {
            return this.type.getLabel() + "\t" + this.getRelativePathString();
        }

        public DiffType getType() {
            return this.type;
        }

        public String getRelativePathString() {
            String path = DFSUtil.bytes2String(this.relativePath);
            if (path.isEmpty()) {
                return ".";
            }
            return "./" + path;
        }

        public byte[] getRelativePath() {
            return this.relativePath;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && other instanceof DiffReportEntry) {
                DiffReportEntry entry = (DiffReportEntry)other;
                return this.type.equals((Object)entry.getType()) && Arrays.equals(this.relativePath, entry.getRelativePath());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.relativePath);
        }
    }

    public static enum DiffType {
        CREATE("+"),
        MODIFY("M"),
        DELETE("-"),
        RENAME("R");

        private String label;

        private DiffType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static DiffType getTypeFromLabel(String label) {
            if (label.equals(CREATE.getLabel())) {
                return CREATE;
            }
            if (label.equals(MODIFY.getLabel())) {
                return MODIFY;
            }
            if (label.equals(DELETE.getLabel())) {
                return DELETE;
            }
            if (label.equals(RENAME.getLabel())) {
                return RENAME;
            }
            return null;
        }
    }
}

