/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.service.logging.LogManager;
import org.apache.hyracks.api.util.InvokeUtil;

public class LogManagerWithReplication
extends LogManager {
    private IReplicationManager replicationManager;
    private IReplicationStrategy replicationStrategy;
    private final Set<Long> replicatedTxn = ConcurrentHashMap.newKeySet();

    public LogManagerWithReplication(ITransactionSubsystem txnSubsystem) {
        super(txnSubsystem);
    }

    @Override
    public void log(ILogRecord logRecord) {
        boolean shouldReplicate;
        boolean bl = shouldReplicate = logRecord.getLogSource() == 0 && logRecord.getLogType() != 6;
        if (shouldReplicate) {
            switch (logRecord.getLogType()) {
                case 0: 
                case 2: 
                case 4: 
                case 7: {
                    shouldReplicate = this.replicationStrategy.isMatch(logRecord.getDatasetId());
                    if (!shouldReplicate || this.replicatedTxn.contains(logRecord.getTxnId())) break;
                    this.replicatedTxn.add(logRecord.getTxnId());
                    break;
                }
                case 1: 
                case 3: {
                    shouldReplicate = this.replicatedTxn.remove(logRecord.getTxnId());
                    break;
                }
                default: {
                    shouldReplicate = false;
                }
            }
        }
        logRecord.setReplicate(shouldReplicate);
        if (logRecord.getLogType() == 4 && logRecord.getLogSource() == 0) {
            this.flushLogsQ.add(logRecord);
            return;
        }
        this.appendToLogTail(logRecord);
    }

    @Override
    protected void appendToLogTail(ILogRecord logRecord) {
        this.syncAppendToLogTail(logRecord);
        if (logRecord.isReplicate()) {
            try {
                this.replicationManager.replicate(logRecord);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ACIDException((Throwable)e);
            }
        }
        if (logRecord.getLogSource() == 0 && LogManagerWithReplication.waitForFlush(logRecord) && !logRecord.isFlushed()) {
            InvokeUtil.doUninterruptibly(() -> {
                ILogRecord iLogRecord = logRecord;
                synchronized (iLogRecord) {
                    while (!logRecord.isFlushed()) {
                        logRecord.wait();
                    }
                    if (logRecord.isReplicate() && (logRecord.getLogType() == 1 || logRecord.getLogType() == 3)) {
                        while (!logRecord.isReplicated()) {
                            logRecord.wait();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void setReplicationManager(IReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
        this.replicationStrategy = replicationManager.getReplicationStrategy();
    }
}

