/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import org.apache.asterix.transaction.management.service.locking.AllocInfo;
import org.apache.asterix.transaction.management.service.locking.JobRecordManager;
import org.apache.asterix.transaction.management.service.locking.RecordManagerStats;
import org.apache.asterix.transaction.management.service.locking.TypeUtil;

public class JobArenaManager {
    public static final boolean TRACK_ALLOC_ID = false;
    private final int noArenas;
    private final JobRecordManager[] arenas;
    private ThreadLocal<LocalManager> local;

    public JobArenaManager(final int noArenas, long txnShrinkTimer) {
        this.noArenas = noArenas;
        this.arenas = new JobRecordManager[noArenas];
        for (int i = 0; i < noArenas; ++i) {
            this.arenas[i] = new JobRecordManager(txnShrinkTimer);
        }
        this.local = new ThreadLocal<LocalManager>(){
            private int nextArena = 0;

            @Override
            protected synchronized LocalManager initialValue() {
                JobRecordManager mgr = JobArenaManager.this.arenas[this.nextArena];
                LocalManager res = new LocalManager();
                res.mgr = mgr;
                res.arenaId = this.nextArena;
                this.nextArena = (this.nextArena + 1) % noArenas;
                return res;
            }
        };
    }

    public long allocate() {
        LocalManager localManager = this.local.get();
        JobRecordManager recMgr = localManager.mgr;
        int allocId = 0;
        int localId = recMgr.allocate();
        long result = TypeUtil.Global.build(localManager.arenaId, allocId, localId);
        assert (TypeUtil.Global.allocId(result) == allocId);
        assert (TypeUtil.Global.arenaId(result) == localManager.arenaId);
        assert (TypeUtil.Global.localId(result) == localId);
        return result;
    }

    public void deallocate(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        this.get(arenaId).deallocate(TypeUtil.Global.localId(slotNum));
    }

    public JobRecordManager get(int i) {
        return this.arenas[i];
    }

    public JobRecordManager local() {
        return this.local.get().mgr;
    }

    public long getLastHolder(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getLastHolder(localId);
    }

    public void setLastHolder(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setLastHolder(localId, value);
    }

    public long getLastWaiter(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getLastWaiter(localId);
    }

    public void setLastWaiter(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setLastWaiter(localId, value);
    }

    public long getLastUpgrader(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getLastUpgrader(localId);
    }

    public void setLastUpgrader(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setLastUpgrader(localId, value);
    }

    public long getTxnId(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getTxnId(localId);
    }

    public void setTxnId(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setTxnId(localId, value);
    }

    public short getAllocId(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getAllocId(localId);
    }

    public void setAllocId(long slotNum, short value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setAllocId(localId, value);
    }

    private void checkAllocId(long slotNum) {
        short curAllocId;
        int refAllocId = TypeUtil.Global.allocId(slotNum);
        if (refAllocId != (curAllocId = this.getAllocId(slotNum))) {
            String msg = "reference to slot " + TypeUtil.Global.toString(slotNum) + " of arena " + TypeUtil.Global.arenaId(slotNum) + " refers to version " + Integer.toHexString(refAllocId) + " current version is " + Integer.toHexString(curAllocId);
            AllocInfo a = this.getAllocInfo(slotNum);
            if (a != null) {
                msg = msg + "\n" + a.toString();
            }
            throw new IllegalStateException(msg);
        }
    }

    public AllocInfo getAllocInfo(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        return this.get(arenaId).getAllocInfo(TypeUtil.Global.localId(slotNum));
    }

    public StringBuilder appendRecord(StringBuilder sb, long slotNum) {
        sb.append("{ ");
        sb.append("\"last holder\" : \"");
        sb = TypeUtil.Global.append(sb, this.getLastHolder(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"last waiter\" : \"");
        sb = TypeUtil.Global.append(sb, this.getLastWaiter(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"last upgrader\" : \"");
        sb = TypeUtil.Global.append(sb, this.getLastUpgrader(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"txn id\" : \"");
        sb = TypeUtil.Global.append(sb, this.getTxnId(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"alloc id\" : \"");
        sb = TypeUtil.Short.append(sb, this.getAllocId(slotNum));
        sb.append("\"");
        return sb.append(" }");
    }

    public StringBuilder append(StringBuilder sb) {
        for (int i = 0; i < this.noArenas; ++i) {
            sb.append("++++ arena ").append(i).append(" ++++\n");
            this.arenas[i].append(sb);
        }
        return sb;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    public RecordManagerStats addTo(RecordManagerStats s) {
        s.arenas += this.noArenas;
        for (int i = 0; i < this.noArenas; ++i) {
            this.arenas[i].addTo(s);
        }
        return s;
    }

    static class LocalManager {
        int arenaId;
        JobRecordManager mgr;

        LocalManager() {
        }
    }
}

