/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.util;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.common.freepage.MutableArrayValueReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.util.ComponentUtils;

public class LSMComponentIdUtils {
    private static final MutableArrayValueReference COMPONENT_ID_MIN_KEY = new MutableArrayValueReference("Component_Id_Min".getBytes());
    private static final MutableArrayValueReference COMPONENT_ID_MAX_KEY = new MutableArrayValueReference("Component_Id_Max".getBytes());

    private LSMComponentIdUtils() {
    }

    public static ILSMComponentId readFrom(IComponentMetadata metadata, ArrayBackedValueStorage buffer) throws HyracksDataException {
        long minId = ComponentUtils.getLong(metadata, (IValueReference)COMPONENT_ID_MIN_KEY, -1L, buffer);
        long maxId = ComponentUtils.getLong(metadata, (IValueReference)COMPONENT_ID_MAX_KEY, -1L, buffer);
        if (minId == -1L || maxId == -1L) {
            return LSMComponentId.MISSING_COMPONENT_ID;
        }
        return new LSMComponentId(minId, maxId);
    }

    public static void persist(ILSMComponentId id, IComponentMetadata metadata) throws HyracksDataException {
        LSMComponentId componentId = (LSMComponentId)id;
        metadata.put((IValueReference)COMPONENT_ID_MIN_KEY, (IValueReference)LongPointable.FACTORY.createPointable(componentId.getMinId()));
        metadata.put((IValueReference)COMPONENT_ID_MAX_KEY, (IValueReference)LongPointable.FACTORY.createPointable(componentId.getMaxId()));
    }

    public static ILSMComponentId union(ILSMComponentId id1, ILSMComponentId id2) {
        long minId = Long.min(((LSMComponentId)id1).getMinId(), ((LSMComponentId)id2).getMinId());
        long maxId = Long.max(((LSMComponentId)id1).getMaxId(), ((LSMComponentId)id2).getMaxId());
        return new LSMComponentId(minId, maxId);
    }
}

