/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.impls.AbstractTreeIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleWriter;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.common.IIndexBulkLoader;

public class LSMIndexBulkLoader
implements IChainedComponentBulkLoader {
    private final IIndexBulkLoader bulkLoader;

    public LSMIndexBulkLoader(IIndexBulkLoader bulkLoader) {
        this.bulkLoader = bulkLoader;
    }

    @Override
    public ITupleReference delete(ITupleReference tuple) throws HyracksDataException {
        ILSMTreeTupleWriter tupleWriter = (ILSMTreeTupleWriter)((AbstractTreeIndex.AbstractTreeIndexBulkLoader)this.bulkLoader).getLeafFrame().getTupleWriter();
        tupleWriter.setAntimatter(true);
        try {
            this.bulkLoader.add(tuple);
        }
        finally {
            tupleWriter.setAntimatter(false);
        }
        return tuple;
    }

    @Override
    public void cleanupArtifacts() throws HyracksDataException {
    }

    @Override
    public ITupleReference add(ITupleReference tuple) throws HyracksDataException {
        this.bulkLoader.add(tuple);
        return tuple;
    }

    @Override
    public void end() throws HyracksDataException {
        this.bulkLoader.end();
    }

    @Override
    public void abort() throws HyracksDataException {
        this.bulkLoader.abort();
    }
}

