/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;

public class LSMComponentIdGenerator
implements ILSMComponentIdGenerator {
    protected long previousTimestamp = -1L;
    private ILSMComponentId componentId;

    public LSMComponentIdGenerator() {
        this.refresh();
    }

    @Override
    public void refresh() {
        long ts = this.getCurrentTimestamp();
        this.componentId = new LSMComponentId(ts, ts);
    }

    @Override
    public ILSMComponentId getId() {
        return this.componentId;
    }

    protected long getCurrentTimestamp() {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= this.previousTimestamp) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            timestamp = System.currentTimeMillis();
        }
        this.previousTimestamp = timestamp;
        return timestamp;
    }
}

