/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.common.IIndexBulkLoader;

public class BloomFilterBulkLoader
implements IChainedComponentBulkLoader {
    private final IIndexBulkLoader bulkLoader;
    private boolean endedBloomFilterLoad = false;

    public BloomFilterBulkLoader(IIndexBulkLoader bulkLoader) {
        this.bulkLoader = bulkLoader;
    }

    @Override
    public ITupleReference add(ITupleReference tuple) throws HyracksDataException {
        this.bulkLoader.add(tuple);
        return tuple;
    }

    @Override
    public ITupleReference delete(ITupleReference tuple) throws HyracksDataException {
        this.bulkLoader.add(tuple);
        return tuple;
    }

    @Override
    public void end() throws HyracksDataException {
        if (!this.endedBloomFilterLoad) {
            this.bulkLoader.end();
            this.endedBloomFilterLoad = true;
        }
    }

    @Override
    public void abort() throws HyracksDataException {
        this.bulkLoader.abort();
    }

    @Override
    public void cleanupArtifacts() throws HyracksDataException {
        if (!this.endedBloomFilterLoad) {
            this.bulkLoader.abort();
            this.endedBloomFilterLoad = true;
        }
    }
}

