/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;

public class BlockingIOOperationCallbackWrapper
implements ILSMIOOperationCallback {
    private boolean notified = false;
    private final ILSMIOOperationCallback wrappedCallback;

    public BlockingIOOperationCallbackWrapper(ILSMIOOperationCallback callback) {
        this.wrappedCallback = callback;
    }

    public synchronized void waitForIO() throws InterruptedException {
        while (!this.notified) {
            this.wait();
        }
        this.notified = false;
    }

    @Override
    public void beforeOperation(ILSMIndexOperationContext opCtx) throws HyracksDataException {
        this.wrappedCallback.beforeOperation(opCtx);
    }

    @Override
    public void afterOperation(ILSMIndexOperationContext opCtx) throws HyracksDataException {
        this.wrappedCallback.afterOperation(opCtx);
    }

    @Override
    public synchronized void afterFinalize(ILSMIndexOperationContext opCtx) throws HyracksDataException {
        this.wrappedCallback.afterFinalize(opCtx);
        this.notifyAll();
        this.notified = true;
    }

    @Override
    public void recycled(ILSMMemoryComponent component, boolean componentSwitched) throws HyracksDataException {
        this.wrappedCallback.recycled(component, componentSwitched);
    }

    @Override
    public void allocated(ILSMMemoryComponent component) throws HyracksDataException {
        this.wrappedCallback.allocated(component);
    }
}

