/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.visitor;

import java.util.ArrayList;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.visitor.base.AbstractAqlAstVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.om.functions.BuiltinFunctions;

public class AqlDeleteRewriteVisitor
extends AbstractAqlAstVisitor<Void, Void> {
    public Void visit(DeleteStatement deleteStmt, Void visitArg) {
        ArrayList<LiteralExpr> arguments = new ArrayList<LiteralExpr>();
        Identifier dataverseName = deleteStmt.getDataverseName();
        Identifier datasetName = deleteStmt.getDatasetName();
        String arg = dataverseName == null ? datasetName.getValue() : dataverseName.getValue() + "." + datasetName.getValue();
        LiteralExpr argumentLiteral = new LiteralExpr((Literal)new StringLiteral(arg));
        arguments.add(argumentLiteral);
        CallExpr callExpression = new CallExpr(new FunctionSignature(BuiltinFunctions.DATASET), arguments);
        ArrayList<Clause> clauseList = new ArrayList<Clause>();
        VariableExpr var = deleteStmt.getVariableExpr();
        ForClause forClause = new ForClause(var, (Expression)callExpression);
        clauseList.add(forClause);
        WhereClause whereClause = null;
        Expression condition = deleteStmt.getCondition();
        if (condition != null) {
            whereClause = new WhereClause(condition);
            clauseList.add((Clause)whereClause);
        }
        VariableExpr returnExpr = new VariableExpr(var.getVar());
        returnExpr.setIsNewVar(false);
        FLWOGRExpression flowgr = new FLWOGRExpression(clauseList, (Expression)returnExpr);
        Query query = new Query(false);
        query.setBody((Expression)flowgr);
        deleteStmt.setQuery(query);
        return null;
    }
}

