/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.visitor;

import java.io.PrintWriter;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.visitor.base.IAQLVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.visitor.FormatPrintVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class AQLFormatPrintVisitor
extends FormatPrintVisitor
implements IAQLVisitor<Void, Integer> {
    public AQLFormatPrintVisitor(PrintWriter out) {
        super(out);
    }

    @Override
    public Void visit(FLWOGRExpression flwor, Integer step) throws CompilationException {
        for (Clause cl : flwor.getClauseList()) {
            cl.accept((ILangVisitor)this, (Object)step);
        }
        this.out.print(this.skip(step) + "return ");
        flwor.getReturnExpr().accept((ILangVisitor)this, (Object)(step + 2));
        return null;
    }

    @Override
    public Void visit(ForClause fc, Integer step) throws CompilationException {
        this.out.print("for ");
        fc.getVarExpr().accept((ILangVisitor)this, (Object)(step + 2));
        if (fc.hasPosVar()) {
            this.out.print(" at ");
            fc.getPosVarExpr().accept((ILangVisitor)this, (Object)(step + 2));
        }
        this.out.print(" in ");
        fc.getInExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println();
        return null;
    }

    @Override
    public Void visit(UnionExpr u, Integer step) throws CompilationException {
        this.printDelimitedExpressions(u.getExprs(), "\n" + this.skip(step) + "union\n", step);
        return null;
    }

    @Override
    public Void visit(DistinctClause dc, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "distinct by ");
        this.printDelimitedExpressions(dc.getDistinctByExpr(), ",", step + 2);
        this.out.println();
        return null;
    }
}

