/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.parser;

import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.metadata.entities.Function;
import org.apache.commons.io.input.CharSequenceReader;

public class FunctionParser {
    private final IParserFactory parserFactory;

    public FunctionParser(IParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    public FunctionDecl getFunctionDecl(Function function) throws CompilationException {
        if (!function.getLanguage().equals("AQL")) {
            throw new CompilationException(1055, new Serializable[]{"AQL", function.getLanguage()});
        }
        String functionBody = function.getFunctionBody();
        List arguments = function.getArguments();
        ArrayList<VarIdentifier> varIdentifiers = new ArrayList<VarIdentifier>();
        StringBuilder builder = new StringBuilder();
        builder.append(" use dataverse " + function.getDataverseName() + ";");
        builder.append(" declare function " + function.getName().split("@")[0]);
        builder.append("(");
        boolean first = true;
        for (String argument : arguments) {
            VarIdentifier varId = new VarIdentifier(argument);
            varIdentifiers.add(varId);
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(argument);
        }
        builder.append("){\n").append(functionBody).append("\n}");
        IParser parser = this.parserFactory.createParser((Reader)new CharSequenceReader((CharSequence)builder));
        List statements = parser.parse();
        FunctionDecl decl = (FunctionDecl)statements.get(1);
        return decl;
    }
}

