/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class EditDistanceStringIsFilterableEvaluator
implements IScalarEvaluator {
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput output = this.resultStorage.getDataOutput();
    protected final IPointable stringPtr = new VoidPointable();
    protected final IPointable edThreshPtr = new VoidPointable();
    protected final IPointable gramLenPtr = new VoidPointable();
    protected final IPointable usePrePostPtr = new VoidPointable();
    protected final IScalarEvaluator stringEval;
    protected final IScalarEvaluator edThreshEval;
    protected final IScalarEvaluator gramLenEval;
    protected final IScalarEvaluator usePrePostEval;
    private final ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();

    public EditDistanceStringIsFilterableEvaluator(IScalarEvaluatorFactory[] args, IHyracksTaskContext context) throws HyracksDataException {
        this.stringEval = args[0].createScalarEvaluator(context);
        this.edThreshEval = args[1].createScalarEvaluator(context);
        this.gramLenEval = args[2].createScalarEvaluator(context);
        this.usePrePostEval = args[3].createScalarEvaluator(context);
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.stringEval.evaluate(tuple, this.stringPtr);
        this.edThreshEval.evaluate(tuple, this.edThreshPtr);
        this.gramLenEval.evaluate(tuple, this.gramLenPtr);
        this.usePrePostEval.evaluate(tuple, this.usePrePostPtr);
        byte typeTag = this.stringPtr.getByteArray()[this.stringPtr.getStartOffset()];
        if (typeTag != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(BuiltinFunctions.EDIT_DISTANCE_STRING_IS_FILTERABLE, Integer.valueOf(0), typeTag, new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
        }
        this.utf8Ptr.set(this.stringPtr.getByteArray(), this.stringPtr.getStartOffset() + 1, this.stringPtr.getLength());
        int strLen = this.utf8Ptr.getStringLength();
        long edThresh = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.EDIT_DISTANCE_LIST_IS_FILTERABLE.getName(), (int)1, (byte[])this.edThreshPtr.getByteArray(), (int)this.edThreshPtr.getStartOffset());
        long gramLen = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.EDIT_DISTANCE_LIST_IS_FILTERABLE.getName(), (int)2, (byte[])this.gramLenPtr.getByteArray(), (int)this.gramLenPtr.getStartOffset());
        typeTag = this.usePrePostPtr.getByteArray()[this.usePrePostPtr.getStartOffset()];
        if (typeTag != ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG) {
            throw new TypeMismatchException(BuiltinFunctions.EDIT_DISTANCE_STRING_IS_FILTERABLE, Integer.valueOf(3), typeTag, new byte[]{ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG});
        }
        boolean usePrePost = ABooleanSerializerDeserializer.getBoolean((byte[])this.usePrePostPtr.getByteArray(), (int)(this.usePrePostPtr.getStartOffset() + 1));
        long numGrams = usePrePost ? (long)strLen + gramLen - 1L : (long)strLen - gramLen + 1L;
        long lowerBound = numGrams - edThresh * gramLen;
        try {
            if (lowerBound <= 0L || strLen == 0) {
                this.booleanSerde.serialize((Object)ABoolean.FALSE, this.output);
            } else {
                this.booleanSerde.serialize((Object)ABoolean.TRUE, this.output);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

