/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.NGramUTF8StringBinaryTokenizer;

public class GramTokensEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    private final int typeIndicatorSize = 1;
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable stringArg = new VoidPointable();
    private final IPointable gramLengthArg = new VoidPointable();
    private final IPointable prePostArg = new VoidPointable();
    private final IScalarEvaluator stringEval;
    private final IScalarEvaluator gramLengthEval;
    private final IScalarEvaluator prePostEval;
    private final NGramUTF8StringBinaryTokenizer tokenizer;
    private final OrderedListBuilder listBuilder = new OrderedListBuilder();
    private final AOrderedListType listType;
    private final TypeChecker typeChecker;

    public GramTokensEvaluator$_EvaluatorGen(IScalarEvaluatorFactory[] args, IHyracksTaskContext context, IBinaryTokenizer tokenizer, BuiltinType itemType) throws HyracksDataException {
        this.stringEval = args[0].createScalarEvaluator(context);
        this.gramLengthEval = args[1].createScalarEvaluator(context);
        this.prePostEval = args[2].createScalarEvaluator(context);
        this.tokenizer = (NGramUTF8StringBinaryTokenizer)tokenizer;
        this.listType = new AOrderedListType((IAType)itemType, null);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.stringEval.evaluate(tuple, this.stringArg);
        if (this.typeChecker.isMissing(this.stringArg, result)) {
            return;
        }
        this.gramLengthEval.evaluate(tuple, this.gramLengthArg);
        if (this.typeChecker.isMissing(this.gramLengthArg, result)) {
            return;
        }
        this.prePostEval.evaluate(tuple, this.prePostArg);
        if (this.typeChecker.isMissing(this.prePostArg, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        int gramLength = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.GRAM_TOKENS.getName(), (int)1, (byte[])this.gramLengthArg.getByteArray(), (int)this.gramLengthArg.getStartOffset());
        this.tokenizer.setGramlength(gramLength);
        boolean prePost = ABooleanSerializerDeserializer.getBoolean((byte[])this.prePostArg.getByteArray(), (int)(this.prePostArg.getStartOffset() + 1));
        this.tokenizer.setPrePost(prePost);
        this.tokenizer.reset(this.stringArg.getByteArray(), this.stringArg.getStartOffset(), this.stringArg.getLength());
        try {
            this.listBuilder.reset((AbstractCollectionType)this.listType);
            while (this.tokenizer.hasNext()) {
                this.tokenizer.next();
                this.listBuilder.addItem(this.tokenizer.getToken());
            }
            this.listBuilder.write(this.out, true);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

