/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;

public class FIFOLocalWriter
implements IFIFOPageWriter {
    public static final FIFOLocalWriter INSTANCE = new FIFOLocalWriter();
    private static boolean DEBUG = false;

    private FIFOLocalWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ICachedPage page, BufferCache bufferCache) throws HyracksDataException {
        CachedPage cPage = (CachedPage)page;
        try {
            bufferCache.write(cPage);
        }
        finally {
            bufferCache.returnPage(cPage);
            if (DEBUG) {
                System.out.println("[FIFO] Return page: " + cPage.cpid + "," + cPage.dpid);
            }
        }
    }

    @Override
    public void sync(int fileId, BufferCache bufferCache) throws HyracksDataException {
        bufferCache.force(fileId, true);
    }
}

