/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;

public class DebugBufferCache
implements IBufferCache {
    private final IBufferCache bufferCache;
    private AtomicLong pinCount = new AtomicLong();
    private AtomicLong unpinCount = new AtomicLong();
    private AtomicLong readLatchCount = new AtomicLong();
    private AtomicLong readUnlatchCount = new AtomicLong();
    private AtomicLong writeLatchCount = new AtomicLong();
    private AtomicLong writeUnlatchCount = new AtomicLong();
    private AtomicLong createFileCount = new AtomicLong();
    private AtomicLong deleteFileCount = new AtomicLong();
    private AtomicLong openFileCount = new AtomicLong();
    private AtomicLong closeFileCount = new AtomicLong();

    public DebugBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
        this.resetCounters();
    }

    @Override
    public int createFile(FileReference fileRef) throws HyracksDataException {
        int fileId = this.bufferCache.createFile(fileRef);
        this.createFileCount.addAndGet(1L);
        return fileId;
    }

    @Override
    public void openFile(int fileId) throws HyracksDataException {
        this.bufferCache.openFile(fileId);
        this.openFileCount.addAndGet(1L);
    }

    @Override
    public void closeFile(int fileId) throws HyracksDataException {
        this.bufferCache.closeFile(fileId);
        this.closeFileCount.addAndGet(1L);
    }

    @Override
    public void deleteFile(int fileId) throws HyracksDataException {
        this.bufferCache.deleteFile(fileId);
        this.deleteFileCount.addAndGet(1L);
    }

    @Override
    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        ICachedPage page = this.bufferCache.pin(dpid, newPage);
        this.pinCount.addAndGet(1L);
        return page;
    }

    @Override
    public void unpin(ICachedPage page) throws HyracksDataException {
        this.bufferCache.unpin(page);
        this.unpinCount.addAndGet(1L);
    }

    @Override
    public int getPageSize() {
        return this.bufferCache.getPageSize();
    }

    @Override
    public int getPageSizeWithHeader() {
        return this.bufferCache.getPageSizeWithHeader();
    }

    @Override
    public int getPageBudget() {
        return this.bufferCache.getPageBudget();
    }

    @Override
    public void close() throws HyracksDataException {
        this.bufferCache.close();
    }

    public void resetCounters() {
        this.pinCount.set(0L);
        this.unpinCount.set(0L);
        this.readLatchCount.set(0L);
        this.readUnlatchCount.set(0L);
        this.writeLatchCount.set(0L);
        this.writeUnlatchCount.set(0L);
        this.createFileCount.set(0L);
        this.deleteFileCount.set(0L);
        this.openFileCount.set(0L);
        this.closeFileCount.set(0L);
    }

    public long getPinCount() {
        return this.pinCount.get();
    }

    public long getUnpinCount() {
        return this.unpinCount.get();
    }

    public long getReadLatchCount() {
        return this.readLatchCount.get();
    }

    public long getReadUnlatchCount() {
        return this.readUnlatchCount.get();
    }

    public long getWriteLatchCount() {
        return this.writeLatchCount.get();
    }

    public long getWriteUnlatchCount() {
        return this.writeUnlatchCount.get();
    }

    public long getCreateFileCount() {
        return this.createFileCount.get();
    }

    public long getDeleteFileCount() {
        return this.deleteFileCount.get();
    }

    public long getOpenFileCount() {
        return this.openFileCount.get();
    }

    public long getCloseFileCount() {
        return this.closeFileCount.get();
    }

    @Override
    public void flush(ICachedPage page) throws HyracksDataException {
        this.bufferCache.flush(page);
    }

    @Override
    public void force(int fileId, boolean metadata) throws HyracksDataException {
        this.bufferCache.force(fileId, metadata);
    }

    @Override
    public int getNumPagesOfFile(int fileId) throws HyracksDataException {
        return this.bufferCache.getNumPagesOfFile(fileId);
    }

    @Override
    public ICachedPage confiscatePage(long dpid) throws HyracksDataException {
        return this.bufferCache.confiscatePage(dpid);
    }

    @Override
    public ICachedPage confiscateLargePage(long dpid, int multiplier, int extraBlockPageId) throws HyracksDataException {
        return this.bufferCache.confiscateLargePage(dpid, multiplier, extraBlockPageId);
    }

    @Override
    public void returnPage(ICachedPage page) {
        this.bufferCache.returnPage(page);
    }

    @Override
    public IFIFOPageQueue createFIFOQueue() {
        return this.bufferCache.createFIFOQueue();
    }

    @Override
    public void finishQueue() throws HyracksDataException {
        this.bufferCache.finishQueue();
    }

    @Override
    public void returnPage(ICachedPage page, boolean reinsert) {
    }

    @Override
    public int getFileReferenceCount(int fileId) {
        return this.bufferCache.getFileReferenceCount(fileId);
    }

    @Override
    public boolean isReplicationEnabled() {
        return false;
    }

    @Override
    public IIOReplicationManager getIOReplicationManager() {
        return null;
    }

    @Override
    public void purgeHandle(int fileId) throws HyracksDataException {
        this.bufferCache.purgeHandle(fileId);
    }

    @Override
    public void resizePage(ICachedPage page, int multiplier, IExtraPageBlockHelper extraPageBlockHelper) throws HyracksDataException {
        this.bufferCache.resizePage(page, multiplier, extraPageBlockHelper);
    }

    @Override
    public int openFile(FileReference fileRef) throws HyracksDataException {
        this.openFileCount.incrementAndGet();
        return this.bufferCache.openFile(fileRef);
    }

    @Override
    public void deleteFile(FileReference file) throws HyracksDataException {
        this.deleteFileCount.incrementAndGet();
        this.bufferCache.deleteFile(file);
    }
}

