/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.QueueInfo;

public class AsyncFIFOPageQueueManager
implements Runnable {
    private static final boolean DEBUG = false;
    protected LinkedBlockingQueue<ICachedPage> queue = new LinkedBlockingQueue();
    volatile Thread writerThread;
    protected AtomicBoolean poisoned = new AtomicBoolean(false);
    protected BufferCache bufferCache;
    protected volatile PageQueue pageQueue;

    public AsyncFIFOPageQueueManager(BufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageQueue createQueue(IFIFOPageWriter writer) {
        if (this.pageQueue == null) {
            AsyncFIFOPageQueueManager asyncFIFOPageQueueManager = this;
            synchronized (asyncFIFOPageQueueManager) {
                if (this.pageQueue == null) {
                    this.writerThread = new Thread(this);
                    this.writerThread.setName("FIFO Writer Thread");
                    this.writerThread.start();
                    this.pageQueue = new PageQueue(this.bufferCache, writer);
                }
            }
        }
        return this.pageQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyQueue() {
        this.poisoned.set(true);
        if (this.writerThread == null) {
            AsyncFIFOPageQueueManager asyncFIFOPageQueueManager = this;
            synchronized (asyncFIFOPageQueueManager) {
                if (this.writerThread == null) {
                    return;
                }
            }
        }
        CachedPage poisonPill = new CachedPage();
        poisonPill.setQueueInfo(new QueueInfo(true, true));
        try {
            CachedPage cachedPage = poisonPill;
            synchronized (cachedPage) {
                this.queue.put(poisonPill);
                while (this.queue.contains(poisonPill)) {
                    poisonPill.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishQueue() throws HyracksDataException {
        if (this.writerThread == null) {
            AsyncFIFOPageQueueManager asyncFIFOPageQueueManager = this;
            synchronized (asyncFIFOPageQueueManager) {
                if (this.writerThread == null) {
                    return;
                }
            }
        }
        try {
            CachedPage lowWater = new CachedPage();
            lowWater.setQueueInfo(new QueueInfo(true, false));
            CachedPage cachedPage = lowWater;
            synchronized (cachedPage) {
                this.queue.put(lowWater);
                while (this.queue.contains(lowWater)) {
                    lowWater.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw HyracksDataException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean die = false;
        while (!die) {
            ICachedPage entry;
            try {
                entry = this.queue.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            if (entry.getQueueInfo() != null && entry.getQueueInfo().hasWaiters()) {
                ICachedPage e = entry;
                synchronized (e) {
                    if (entry.getQueueInfo().isPoison()) {
                        die = true;
                    }
                    entry.notifyAll();
                    continue;
                }
            }
            try {
                this.pageQueue.getWriter().write(entry, this.bufferCache);
            }
            catch (HyracksDataException e) {
                e.printStackTrace();
            }
        }
    }

    protected class PageQueue
    implements IFIFOPageQueue {
        final IBufferCache bufferCache;
        public final IFIFOPageWriter writer;

        protected PageQueue(IBufferCache bufferCache, IFIFOPageWriter writer) {
            this.bufferCache = bufferCache;
            this.writer = writer;
        }

        protected IBufferCache getBufferCache() {
            return this.bufferCache;
        }

        protected IFIFOPageWriter getWriter() {
            return this.writer;
        }

        @Override
        public void put(ICachedPage page) throws HyracksDataException {
            try {
                if (AsyncFIFOPageQueueManager.this.poisoned.get()) {
                    throw new HyracksDataException("Queue is closing");
                }
                AsyncFIFOPageQueueManager.this.queue.put(page);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }
}

