/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.HashSet;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushNestedOrderByUnderPreSortedGroupByRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        if (op.getPhysicalOperator() == null) {
            return false;
        }
        AbstractPhysicalOperator pOp = (AbstractPhysicalOperator)op.getPhysicalOperator();
        if (pOp.getOperatorTag() != PhysicalOperatorTag.PRE_CLUSTERED_GROUP_BY) {
            return false;
        }
        GroupByOperator gby = (GroupByOperator)op;
        if (gby.getNestedPlans().isEmpty()) {
            return false;
        }
        ILogicalPlan plan = (ILogicalPlan)gby.getNestedPlans().get(0);
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)((Mutable)plan.getRoots().get(0)).getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        Mutable opRef2 = (Mutable)op1.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.ORDER) {
            return false;
        }
        OrderOperator order1 = (OrderOperator)op2;
        if (!this.isIndependentFromChildren(order1)) {
            return false;
        }
        AbstractPhysicalOperator pOrder1 = (AbstractPhysicalOperator)op2.getPhysicalOperator();
        if (pOrder1.getOperatorTag() != PhysicalOperatorTag.STABLE_SORT && pOrder1.getOperatorTag() != PhysicalOperatorTag.IN_MEMORY_STABLE_SORT) {
            return false;
        }
        AbstractLogicalOperator op3 = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        if (op3.getOperatorTag() != LogicalOperatorTag.ORDER) {
            return false;
        }
        AbstractPhysicalOperator pOp3 = (AbstractPhysicalOperator)op3.getPhysicalOperator();
        if (pOp3.getOperatorTag() != PhysicalOperatorTag.STABLE_SORT) {
            return false;
        }
        OrderOperator order2 = (OrderOperator)op3;
        StableSortPOperator sort2 = (StableSortPOperator)pOp3;
        for (Pair oe : order1.getOrderExpressions()) {
            order2.getOrderExpressions().add(oe);
        }
        sort2.computeDeliveredProperties((ILogicalOperator)order2, null);
        ILogicalOperator underOrder1 = (ILogicalOperator)((Mutable)order1.getInputs().get(0)).getValue();
        opRef2.setValue((Object)underOrder1);
        return true;
    }

    private boolean isIndependentFromChildren(OrderOperator order1) throws AlgebricksException {
        HashSet free = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc((AbstractLogicalOperator)order1, free);
        HashSet usedInOrder = new HashSet();
        VariableUtilities.getUsedVariables((ILogicalOperator)order1, usedInOrder);
        return free.containsAll(usedInOrder);
    }
}

