/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import java.nio.ByteBuffer;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class TransactionUtil {
    private TransactionUtil() {
    }

    public static void formJobTerminateLogRecord(ITransactionContext txnCtx, LogRecord logRecord, boolean isCommit) {
        logRecord.setTxnCtx(txnCtx);
        TransactionUtil.formJobTerminateLogRecord(logRecord, txnCtx.getTxnId().getId(), isCommit);
    }

    public static void formJobTerminateLogRecord(LogRecord logRecord, long txnId, boolean isCommit) {
        logRecord.setLogType(isCommit ? (byte)1 : 3);
        logRecord.setDatasetId(-1);
        logRecord.setPKHashValue(-1);
        logRecord.setTxnId(txnId);
        logRecord.computeAndSetLogSize();
    }

    public static void formFlushLogRecord(LogRecord logRecord, int datasetId, int resourcePartition, long flushingComponentMinId, long flushingComponentMaxId, PrimaryIndexOperationTracker opTracker) {
        logRecord.setLogType((byte)4);
        logRecord.setTxnId(-1L);
        logRecord.setDatasetId(datasetId);
        logRecord.setResourcePartition(resourcePartition);
        logRecord.setFlushingComponentMinId(flushingComponentMinId);
        logRecord.setFlushingComponentMaxId(flushingComponentMaxId);
        logRecord.setOpTracker(opTracker);
        logRecord.computeAndSetLogSize();
    }

    public static void formEntityCommitLogRecord(LogRecord logRecord, ITransactionContext txnCtx, int datasetId, int PKHashValue, ITupleReference PKValue, int[] PKFields, int resourcePartition, byte entityCommitType) {
        logRecord.setTxnCtx(txnCtx);
        logRecord.setLogType(entityCommitType);
        logRecord.setTxnId(txnCtx.getTxnId().getId());
        logRecord.setDatasetId(datasetId);
        logRecord.setPKHashValue(PKHashValue);
        logRecord.setPKFieldCnt(PKFields.length);
        logRecord.setPKValue(PKValue);
        logRecord.setPKFields(PKFields);
        logRecord.setResourcePartition(resourcePartition);
        logRecord.computeAndSetPKValueSize();
        logRecord.computeAndSetLogSize();
    }

    public static void formMarkerLogRecord(LogRecord logRecord, ITransactionContext txnCtx, int datasetId, int resourcePartition, ByteBuffer marker) {
        logRecord.setTxnCtx(txnCtx);
        logRecord.setLogSource((byte)0);
        logRecord.setLogType((byte)8);
        logRecord.setTxnId(txnCtx.getTxnId().getId());
        logRecord.setDatasetId(datasetId);
        logRecord.setResourcePartition(resourcePartition);
        marker.get();
        logRecord.setMarker(marker);
        logRecord.computeAndSetLogSize();
    }
}

