/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

public final class CodeGenHelper {
    public static final String DEFAULT_SUFFIX_FOR_GENERATED_CLASS = "Gen";
    private static final String DOLLAR = "$";
    private static final String NESTED_CLASSNAME_PREFIX = "_";

    public static String getGeneratedClassName(String originalClassName, String suffixForGeneratedClass) {
        return CodeGenHelper.toJdkStandardName(CodeGenHelper.getGeneratedInternalClassName(originalClassName, suffixForGeneratedClass));
    }

    public static String getGeneratedInternalClassName(String originalClassName, String suffixForGeneratedClass) {
        String originalFuncDescriptorClassInternalName = CodeGenHelper.toInternalClassName(originalClassName);
        return CodeGenHelper.generateClassName(originalFuncDescriptorClassInternalName, suffixForGeneratedClass, 0);
    }

    public static String generateClassName(String originalClassName, String suffix, int counter) {
        StringBuilder sb = new StringBuilder();
        int end = originalClassName.indexOf(DOLLAR);
        if (end < 0) {
            end = originalClassName.length();
        }
        String name = originalClassName.substring(0, end);
        sb.append(name);
        sb.append(DOLLAR);
        sb.append(NESTED_CLASSNAME_PREFIX);
        sb.append(suffix);
        if (counter > 0) {
            sb.append(counter);
        }
        return sb.toString();
    }

    public static String toJdkStandardName(String name) {
        return name.replace("/", ".");
    }

    public static String toInternalClassName(String name) {
        return name.replace(".", "/");
    }

    private CodeGenHelper() {
    }
}

