/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class Checkpoint
implements Comparable<Checkpoint> {
    private final long checkpointLsn;
    private final long minMCTFirstLsn;
    private final long maxTxnId;
    private final long timeStamp;
    private final boolean sharp;
    private final int storageVersion;

    @JsonCreator
    public Checkpoint(@JsonProperty(value="checkpointLsn") long checkpointLsn, @JsonProperty(value="minMCTFirstLsn") long minMCTFirstLsn, @JsonProperty(value="maxJobId") long maxTxnId, @JsonProperty(value="timeStamp") long timeStamp, @JsonProperty(value="sharp") boolean sharp, @JsonProperty(value="storageVersion") int storageVersion) {
        this.checkpointLsn = checkpointLsn;
        this.minMCTFirstLsn = minMCTFirstLsn;
        this.maxTxnId = maxTxnId;
        this.timeStamp = timeStamp;
        this.sharp = sharp;
        this.storageVersion = storageVersion;
    }

    public long getCheckpointLsn() {
        return this.checkpointLsn;
    }

    public long getMinMCTFirstLsn() {
        return this.minMCTFirstLsn;
    }

    public long getMaxTxnId() {
        return this.maxTxnId;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isSharp() {
        return this.sharp;
    }

    public int getStorageVersion() {
        return this.storageVersion;
    }

    @Override
    public int compareTo(Checkpoint checkpoint) {
        long compareTimeStamp = checkpoint.getTimeStamp();
        long diff = compareTimeStamp - this.timeStamp;
        if (diff > 0L) {
            return 1;
        }
        if (diff == 0L) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Checkpoint)) {
            return false;
        }
        Checkpoint other = (Checkpoint)obj;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.checkpointLsn ^ this.checkpointLsn >>> 32);
        result = 31 * result + Long.hashCode(this.maxTxnId);
        result = 31 * result + (int)(this.minMCTFirstLsn ^ this.minMCTFirstLsn >>> 32);
        result = 31 * result + (this.sharp ? 1231 : 1237);
        result = 31 * result + this.storageVersion;
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        return result;
    }

    public String asJson() throws HyracksDataException {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static Checkpoint fromJson(String json) throws HyracksDataException {
        try {
            return (Checkpoint)new ObjectMapper().readValue(json, Checkpoint.class);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

