/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.freepage.MutableArrayValueReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.util.ComponentUtils;
import org.apache.hyracks.storage.am.lsm.common.util.LSMComponentIdUtils;

public abstract class AbstractLSMIOOperationCallback
implements ILSMIOOperationCallback {
    public static final MutableArrayValueReference LSN_KEY = new MutableArrayValueReference("LSN".getBytes());
    public static final long INVALID = -1L;
    protected final ILSMIndex lsmIndex;
    protected final long[] firstLSNs;
    protected final boolean[] flushRequested;
    protected final long[] mutableLastLSNs;
    protected int readIndex;
    protected int writeIndex;
    protected int recycleIndex;
    protected boolean hasFlushed;
    protected ILSMComponentId[] nextComponentIds;
    protected final ILSMComponentIdGenerator idGenerator;
    protected final ArrayBackedValueStorage buffer = new ArrayBackedValueStorage(8);
    private final IIndexCheckpointManagerProvider indexCheckpointManagerProvider;
    private final Map<ILSMComponentId, Long> componentLsnMap = new HashMap<ILSMComponentId, Long>();

    public AbstractLSMIOOperationCallback(ILSMIndex lsmIndex, ILSMComponentIdGenerator idGenerator, IIndexCheckpointManagerProvider indexCheckpointManagerProvider) {
        this.lsmIndex = lsmIndex;
        this.idGenerator = idGenerator;
        this.indexCheckpointManagerProvider = indexCheckpointManagerProvider;
        int count = lsmIndex.getNumberOfAllMemoryComponents();
        this.mutableLastLSNs = new long[count];
        this.firstLSNs = new long[count];
        this.flushRequested = new boolean[count];
        this.readIndex = 0;
        this.writeIndex = 0;
        this.recycleIndex = 0;
        this.hasFlushed = false;
        this.nextComponentIds = new ILSMComponentId[count];
        if (count > 0) {
            this.nextComponentIds[0] = idGenerator.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeOperation(ILSMIndexOperationContext opCtx) throws HyracksDataException {
        if (opCtx.getIoOperationType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            AbstractLSMIOOperationCallback abstractLSMIOOperationCallback = this;
            synchronized (abstractLSMIOOperationCallback) {
                this.flushRequested[this.writeIndex] = true;
                this.writeIndex = (this.writeIndex + 1) % this.mutableLastLSNs.length;
                if (this.writeIndex != this.readIndex) {
                    this.firstLSNs[this.writeIndex] = this.mutableLastLSNs[this.writeIndex];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterOperation(ILSMIndexOperationContext opCtx) throws HyracksDataException {
        if (opCtx.getNewComponent() == null) {
            return;
        }
        this.putLSNIntoMetadata(opCtx.getNewComponent(), opCtx.getComponentsToBeMerged());
        this.putComponentIdIntoMetadata(opCtx.getIoOperationType(), opCtx.getNewComponent(), opCtx.getComponentsToBeMerged());
        this.componentLsnMap.put(opCtx.getNewComponent().getId(), this.getComponentLSN(opCtx.getComponentsToBeMerged()));
        if (opCtx.getIoOperationType() == ILSMIOOperation.LSMIOOperationType.MERGE) {
            if (opCtx.getComponentsToBeMerged().isEmpty()) {
                throw new IllegalStateException("Merge must have old components");
            }
            LongPointable markerLsn = LongPointable.FACTORY.createPointable(ComponentUtils.getLong((IComponentMetadata)((ILSMDiskComponent)opCtx.getComponentsToBeMerged().get(0)).getMetadata(), (IValueReference)ComponentUtils.MARKER_LSN_KEY, (long)-1L, (ArrayBackedValueStorage)this.buffer));
            opCtx.getNewComponent().getMetadata().put((IValueReference)ComponentUtils.MARKER_LSN_KEY, (IValueReference)markerLsn);
        } else if (opCtx.getIoOperationType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            AbstractLSMIOOperationCallback abstractLSMIOOperationCallback = this;
            synchronized (abstractLSMIOOperationCallback) {
                this.flushRequested[this.readIndex] = false;
                if (this.readIndex == this.writeIndex) {
                    this.firstLSNs[this.writeIndex] = this.mutableLastLSNs[this.writeIndex];
                }
                this.readIndex = (this.readIndex + 1) % this.mutableLastLSNs.length;
            }
        }
    }

    public void afterFinalize(ILSMIndexOperationContext opCtx) throws HyracksDataException {
        if (opCtx.getIoOperationType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            this.hasFlushed = true;
            if (opCtx.getNewComponent() != null) {
                Long lsn = this.componentLsnMap.remove(opCtx.getNewComponent().getId());
                if (lsn == null) {
                    throw new IllegalStateException("Unidentified flushed component: " + opCtx.getNewComponent());
                }
                Optional componentFile = opCtx.getNewComponent().getLSMComponentPhysicalFiles().stream().findAny();
                if (componentFile.isPresent()) {
                    ResourceReference ref = ResourceReference.of((String)componentFile.get());
                    String componentEndTime = AbstractLSMIndexFileManager.getComponentEndTime((String)ref.getName());
                    this.indexCheckpointManagerProvider.get(ref).flushed(componentEndTime, lsn);
                }
            }
        }
    }

    private void putLSNIntoMetadata(ILSMDiskComponent newComponent, List<? extends ILSMComponent> oldComponents) throws HyracksDataException {
        newComponent.getMetadata().put((IValueReference)LSN_KEY, (IValueReference)LongPointable.FACTORY.createPointable(this.getComponentLSN(oldComponents)));
    }

    public static long getTreeIndexLSN(DiskComponentMetadata md) throws HyracksDataException {
        LongPointable pointable = new LongPointable();
        IMetadataPageManager metadataPageManager = md.getMetadataPageManager();
        metadataPageManager.get(metadataPageManager.createMetadataFrame(), (IValueReference)LSN_KEY, (IPointable)pointable);
        return pointable.getLength() == 0 ? -1L : pointable.longValue();
    }

    private ILSMComponentId getMergedComponentId(List<? extends ILSMComponent> mergedComponents) throws HyracksDataException {
        if (mergedComponents.isEmpty()) {
            return null;
        }
        return LSMComponentIdUtils.union((ILSMComponentId)mergedComponents.get(0).getId(), (ILSMComponentId)mergedComponents.get(mergedComponents.size() - 1).getId());
    }

    private void putComponentIdIntoMetadata(ILSMIOOperation.LSMIOOperationType opType, ILSMDiskComponent newComponent, List<? extends ILSMComponent> oldComponents) throws HyracksDataException {
        if (opType == ILSMIOOperation.LSMIOOperationType.MERGE) {
            ILSMComponentId componentId = this.getMergedComponentId(oldComponents);
            LSMComponentIdUtils.persist((ILSMComponentId)componentId, (IComponentMetadata)newComponent.getMetadata());
        }
    }

    public synchronized void updateLastLSN(long lastLSN) {
        if (!this.flushRequested[this.writeIndex]) {
            this.mutableLastLSNs[this.writeIndex] = lastLSN;
            if (this.hasFlushed || this.lsmIndex.isMemoryComponentsAllocated()) {
                this.nextComponentIds[this.writeIndex] = this.idGenerator.getId();
            }
        }
    }

    public void forceRefreshNextId() {
        this.nextComponentIds[this.writeIndex] = this.idGenerator.getId();
    }

    public synchronized void setFirstLSN(long firstLSN) {
        this.firstLSNs[this.writeIndex] = firstLSN;
    }

    public synchronized long getFirstLSN() {
        return this.firstLSNs[this.readIndex];
    }

    public synchronized boolean hasPendingFlush() {
        for (int i = 0; i < this.flushRequested.length; ++i) {
            if (!this.flushRequested[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getComponentLSN(List<? extends ILSMComponent> diskComponents) throws HyracksDataException {
        if (diskComponents.isEmpty()) {
            AbstractLSMIOOperationCallback abstractLSMIOOperationCallback = this;
            synchronized (abstractLSMIOOperationCallback) {
                return this.mutableLastLSNs[this.readIndex];
            }
        }
        long maxLSN = -1L;
        for (ILSMComponent iLSMComponent : diskComponents) {
            DiskComponentMetadata md = ((ILSMDiskComponent)iLSMComponent).getMetadata();
            maxLSN = Math.max(AbstractLSMIOOperationCallback.getTreeIndexLSN(md), maxLSN);
        }
        return maxLSN;
    }

    private synchronized ILSMComponentId getLSMComponentId() {
        return this.nextComponentIds[this.recycleIndex];
    }

    public void recycled(ILSMMemoryComponent component, boolean componentSwitched) throws HyracksDataException {
        ILSMComponentId componentId = this.getLSMComponentId();
        component.resetId(componentId, false);
        if (componentSwitched) {
            this.recycleIndex = (this.recycleIndex + 1) % this.nextComponentIds.length;
        }
    }

    public void allocated(ILSMMemoryComponent component) throws HyracksDataException {
        if (component == this.lsmIndex.getCurrentMemoryComponent()) {
            ILSMComponentId componentId = this.getLSMComponentId();
            component.resetId(componentId, false);
        }
    }
}

