/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.context.ITransactionOperationTracker;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public class BaseOperationTracker
implements ITransactionOperationTracker {
    protected final int datasetID;
    protected final DatasetInfo dsInfo;

    public BaseOperationTracker(int datasetID, DatasetInfo dsInfo) {
        this.datasetID = datasetID;
        this.dsInfo = dsInfo;
    }

    public void beforeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.FLUSH || opType == LSMOperationType.MERGE || opType == LSMOperationType.REPLICATE) {
            this.dsInfo.declareActiveIOOperation();
        }
    }

    public void afterOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.REPLICATE) {
            this.dsInfo.undeclareActiveIOOperation();
        }
    }

    public void completeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.FLUSH || opType == LSMOperationType.MERGE) {
            this.dsInfo.undeclareActiveIOOperation();
        }
    }

    @Override
    public void beforeTransaction(long resourceId) {
        this.dsInfo.touch();
        this.dsInfo.getIndexes().get(resourceId).touch();
    }

    @Override
    public void afterTransaction(long resourceId) {
        this.dsInfo.untouch();
        this.dsInfo.getIndexes().get(resourceId).untouch();
    }

    public DatasetInfo getDatasetInfo() {
        return this.dsInfo;
    }
}

